#ifndef PICKUPORDERWORK_H
#define PICKUPORDERWORK_H

#include <QEvent>
#include <QString>
#include <QJsonObject>
#include <QTimer>
#include <QEventLoop>
#include "workobject.h"
#include "preDefine.h"
#include "base/Arithmetic/cretopt.h"

#define ADVANCEORDER 0

class PickUpOrderWork : public WorkObject
{   
    Q_OBJECT
public:
    typedef enum {
        PickUp_PRT = 2,
        PickUp_PRTAndRemind = 3,
        PickUp_Remind = 4,
    } PickUpOrderOPT;

    explicit PickUpOrderWork(WorkObject *parent = 0);

    ~PickUpOrderWork();

    bool event(QEvent *e);

    bool OptPickUpOrder(QString orderid, int opt, const int &prtstatus, const int remindstatus, bool &needwaitprt);

    void setUrl(const QString &url);

signals:

public slots:

private:
    bool ResponsePickUpOrderOpt(QString orderid, int opt, bool needwaitprt);
private:
    QString _url;
};

class PickOrderDataProcess
{
public:
    friend class PickUpOrderWork;
private:
    static bool getAction(int REQ, QString &action)
    {
#ifndef USE_QAACTION
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("saas.order.processAdvanceOrder");
                return true;
            default:
                return false;
        }
#else
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("qasaas.order.processAdvanceOrder");
                return true;
            default:
                return false;
        }
#endif
    }

    static bool getAccess_Token(QString &access_toekn)
    {
        access_toekn = DEFAULT_ACCESS_TOKEN;
        return true;
    }

    static bool getVer(QString &ver)
    {
        ver = "1";
        return true;
    }

    static bool getRealUrl(int reqtype, const QJsonObject &json, const QString &url, QString &realurl)
    {

        QString action, access_token, ver, sign;

        if(!PickOrderDataProcess::requestGetRSASign(reqtype, json, sign, action, access_token, ver))
            return false;

        QString tmpurl = url;

        realurl = tmpurl.arg(action, access_token, ver, sign);

        return true;
    }

    static bool requestGetRSASign(int reqtype, const QJsonObject &json, QString &sign, QString &action, QString &access_token, QString &ver)
    {
        QJsonObject tmpjson;

        if(!PickOrderDataProcess::getAction(reqtype, action) ||
            !PickOrderDataProcess::getAccess_Token(access_token) ||
                !PickOrderDataProcess::getVer(ver))
            return false;

        PickOrderDataProcess::getComplateJson(action, access_token, ver, json, tmpjson);
        return CretOperate::GetSign(tmpjson, sign);
    }

    static void getComplateJson(QString action, QString access_token, QString ver, const QJsonObject &json, QJsonObject &complatejson)
    {
        complatejson = json;

        complatejson.insert(JSON_KEY_ACTION, action);
        complatejson.insert(JSON_KEY_ACCESS_TOKEN, access_token);
        complatejson.insert(JSON_KEY_VER, ver);
    }

    static bool getPickUpOrderOptRequest(QJsonObject &data, QString orderid, int opt)
    {
        data.insert(JSON_KEY_PIVKUP_ORDERID, orderid);
        data.insert(JSON_KEY_PIVKUP_OPT, opt);
        return true;
    }

};

#endif // PICKUPORDERWORK_H
