#include <QVariantMap>
#include "pickuporderwork.h"
#include "model/posorderpool.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"

PickUpOrderWork::PickUpOrderWork(WorkObject *parent) : WorkObject(parent)
{
    FMApplication::subscibeEvent(this, PosEvent::s_pickuporder_opt);
}

PickUpOrderWork::~PickUpOrderWork()
{

    QLOG_DEBUG() << "PickUpOrderWork quit";
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

bool PickUpOrderWork:: event(QEvent *e)
{
    if(e->type() == PosEvent::s_pickuporder_opt)
    {
        QLOG_INFO() << "PosEvent::s_pickuporder_opt" << QThread::currentThreadId();

        QVariantMap info;

        GETEVENTINFO(info,e,QVariantMap);

        QLOG_DEBUG() << "PickUpOrderWork::PosEvent::s_pickuporder_opt" << info;

        if(!info.contains(EVENT_KEY_ORDERID) || !info.contains(EVENT_KEY_STATUS))
            return true;

        QString orderid = info[EVENT_KEY_ORDERID].toString();
        int optid = info[EVENT_KEY_STATUS].toInt();
        int ptfstaus = 0;
        int remindstatus = 0;
        bool needwaitprt = false;

        QLOG_DEBUG() << "PosOrderPool::GetPickUpOrderPrtAndRemid started";

        if(!PosOrderPool::GetPickUpOrderPrtAndRemid(orderid, ptfstaus, remindstatus))
            return false;

        QLOG_DEBUG() << "orderid : " << orderid << "; ptfstaus : " << ptfstaus << "; remindstatus" << remindstatus;

        if(OptPickUpOrder(orderid, optid, ptfstaus, remindstatus, needwaitprt))
        {
            QLOG_DEBUG() << "needwaitprt : " << needwaitprt;

            //等待打印结果
            if(needwaitprt)
            {
                QEventLoop loop;
                QTimer timer;

                connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
                connect(this, &PickUpOrderWork::quit, &loop, &QEventLoop::quit);

                timer.start(5*1000);
            }

            ResponsePickUpOrderOpt(orderid, optid, needwaitprt);
        }

        return true;
    }

    return WorkObject::event(e);
}

bool PickUpOrderWork::ResponsePickUpOrderOpt(QString orderid, int opt, bool needwaitprt)
{
    QLOG_DEBUG() << "PickUpOrderWork::ResponsePickUpOrderOpt start";

    if(needwaitprt)
    {
        int ptfstaus = 0;
        int remindstatus = 0;

        if(!PosOrderPool::GetPickUpOrderPrtAndRemid(orderid, ptfstaus, remindstatus))
        {
            QLOG_ERROR() << "ResponsePickUpOrderOpt : GetPickUpOrderPrtAndRemid failed";
            return false;
        }

        if(ptfstaus != 1)
            return false;
    }

    QLOG_DEBUG() << "start reposne pickup order opt";

    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!PickOrderDataProcess::getPickUpOrderOptRequest(json, orderid, opt))
    {
        QLOG_ERROR() << "getPickUpOrderOptRequest failed";
        return false;
    }

    QLOG_INFO() << "PickUpOrderWork request json : " << json;

    if(!PickOrderDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "PickUpOrderWork getRealUrl failed";
        return false;
    }

    QLOG_INFO() << "PickUpOrderWork request url :" << realurl;

    if(!this->S_Request(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "ResponsePickUpOrderOpt failed : " << error;
        return false;
    }

    QLOG_INFO() << "ResponsePickUpOrderOpt return json : " << recvjson;

}

void PickUpOrderWork::setUrl(const QString &url)
{
    _url = url;
}

bool PickUpOrderWork::OptPickUpOrder(QString orderid, int opt, const int &prtstatus, const int remindstatus, bool &needwaitprt)
{
    switch (opt) {
    case PickUp_PRT:
        if(prtstatus == 0)
        {
            QVariantMap map;
            map.insert(EVENT_KEY_ORDERID, orderid);
            map.insert(EVENT_KEY_MSG, DEFAULT_LOCATION_PRINT);
            POSTEVENTTYPE(PosEvent::s_order_location, map, QVariantMap);
            needwaitprt = true;
        }
        break;
    case PickUp_PRTAndRemind:
        if(prtstatus == 0)
        {
            QVariantMap map;
            map.insert(EVENT_KEY_ORDERID, orderid);
            map.insert(EVENT_KEY_MSG, DEFAULT_LOCATION_PRINT);
            POSTEVENTTYPE(PosEvent::s_order_location, map, QVariantMap);
            needwaitprt = true;
        }
        if(remindstatus == 0)
            DEFAULTPOSTEVENT(PosEvent::s_pickuporder_remind, orderid);
        break;
    case PickUp_Remind:
        if(remindstatus == 0)
            DEFAULTPOSTEVENT(PosEvent::s_pickuporder_remind, orderid);
        break;
    default:
        return false;
    }
    return true;
}

