﻿#ifndef ORDERPRINTWORK_H
#define ORDERPRINTWORK_H

#include <QObject>
#include "workobject.h"
#include "model/orderObject.h"

class orderprintwork : public WorkObject
{
    Q_OBJECT
public:
    explicit orderprintwork(WorkObject *parent = 0);

    virtual bool event(QEvent *e);
private:
    void Print(const QString &orderid);
    //获取打印模板;
    bool GetPrtTemplet(int prttype, int pagew, QString &context, const OrderObject &order);
    //小票打印
    void DoPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag);
    //标签打印
    void DoLabelPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag);
    //后厨打印
    void DoBackPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag);
    //工具函数
    void MapToString(const QVariantMap map, QString &config);
    //展示订单打印结果
    void ResultShow(const QString &orderid, bool flag);
};

#endif // ORDERPRINTWORK_H
