﻿#include "orderprintwork.h"

#include "preDefine.h"

#include "event/fmapplication.h"
#include "event/posevent.h"

#include "model/orderObject.h"
#include "model/posorderpool.h"

//#include "base/Print/printlib.h"
#include "newprintlib.h"
#include "model/posprtpool.h"
#include "model/posstallspool.h"

#include "QsLog.h"

#include <QFile>
#include <QByteArray>
#include <QJsonDocument>

#include <QSettings>

orderprintwork::orderprintwork(WorkObject *parent) : WorkObject(parent)
{
    //订阅订单本地化事件
    FMApplication::subscibeEvent(this, PosEvent::s_order_location);
}

bool orderprintwork::event(QEvent *e)
{
        if(e->type() == PosEvent::s_order_location)
        {
            QVariantMap map;

            GETEVENTINFO(map, e, QVariantMap);

            if(map.contains(EVENT_KEY_ORDERID) && map.contains(EVENT_KEY_MSG) &&
                    map[EVENT_KEY_MSG].toInt() == DEFAULT_LOCATION_PRINT)
            {
                QString orderid = map[EVENT_KEY_ORDERID].toString();

                QLOG_DEBUG() << "orderid : " << orderid;

                Print(orderid);
            }
            return true;
        }

       return WorkObject::event(e);

}

void orderprintwork::Print(const QString &orderid)
{
    QStringList prtlist = PosPrtPool::prtlist();

    bool flag = false;

    foreach (auto v, prtlist) {
        int prttype;

        QVariantMap map;

        if(!PosPrtPool::GetPrtType(v, prttype))
        {
            QLOG_ERROR() << "orderprintwork::Print::PosPrtPool::GetPrtType failed";
            return ;
        }

        if(!PosPrtPool::GetPrtConfig(v, map))
        {
            QLOG_ERROR() << "orderprintwork::Print::PosPrtPool::GetPrtConfig failed";
            return ;
        }

        switch (prttype) {
        case 0:
            DoPrint(v, orderid, map, flag);
            QLOG_DEBUG()  << "DoPrint" << flag;
            break;
        case 1:
            DoLabelPrint(v, orderid, map, flag);
            QLOG_DEBUG()  << "DoLabelPrint" << flag;
            break;
        case 2:
            DoBackPrint(v, orderid, map, flag);
            QLOG_DEBUG()  << "DoBackPrint" << flag;
            break;
        default:
            return ;
        }

        if(flag == false)
            break;
    }

    ResultShow(orderid, flag);
}

bool orderprintwork::GetPrtTemplet(int prttype, int pagew, QString &context, const OrderObject &order)
{
    QFile file;

    QLOG_DEBUG() << "prttype:" << prttype;



    if(prttype == 0)
    {
        if(pagew > 56)
        {
//            if(QString("saas").compare(order.channel, Qt::CaseInsensitive) == 0)
//            {
                if(order.order_type == 1)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_TAKEOUT80_TEMPLATE);

                }
                else if(order.order_type == 2)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_YYTAKEOUT80_TEMPLATE);
                }
                else if(order.order_type == 3 || order.order_type == 5)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_INTAKE80_TEMPLATE);
                }
                else if(order.order_type == 6 || order.order_type == 4)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_YYINTAKE80_TEMPLATE);
                }
//            }
//            else
//            {
//                if(order.order_type == 1 || order.order_type == 2)
//                {
//                        file.setFileName(qApp->applicationDirPath() + "/" + XML_TAKEOUT80_TEMPLATE);
//                }
//                else
//                {
//                        file.setFileName(qApp->applicationDirPath() + "/" + XML_INTAKE80_TEMPLATE);
//                }
//            }
        }
        else
        {
//            if(QString("saas").compare(order.channel, Qt::CaseInsensitive) == 0)
//            {
                if(order.order_type == 1)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_TAKEOUT56_TEMPLATE);
                }
                else if(order.order_type == 2)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_YYTAKEOUT56_TEMPLATE);
                }
                else if(order.order_type == 3 || order.order_type == 5)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_INTAKE56_TEMPLATE);
                }
                else if(order.order_type == 6 || order.order_type == 4)
                {
                    file.setFileName(qApp->applicationDirPath() + "/" + XML_YYINTAKE56_TEMPLATE);
                }
//            }
//            else
//            {
//                if(order.order_type == 1 || order.order_type == 2)
//                {
//                        file.setFileName(qApp->applicationDirPath() + "/" + XML_TAKEOUT56_TEMPLATE);
//                }
//                else
//                {
//                        file.setFileName(qApp->applicationDirPath() + "/" + XML_INTAKE56_TEMPLATE);
//                }
//            }
        }
    }
    else if(prttype == 2)
    {
        if(pagew > 56)
        {
            file.setFileName(qApp->applicationDirPath() + "/" + XML_BACK80_TEMPLATE);
        }
        else
        {
            file.setFileName(qApp->applicationDirPath() + "/" + XML_BACK_TEMPLATE);
        }
    }
    else if(prttype == 1)
    {
        file.setFileName(qApp->applicationDirPath() + "/" + XML_LABEL_TEMPLATE);
    }

    QLOG_DEBUG() << "file : " << file.fileName();

    if(file.open(QFile::ReadOnly))
    {
        QByteArray data = file.readAll();

        context = QString::fromUtf8(data);

        QLOG_DEBUG() << "Context size : " << context.size();

        file.close();
        return true;
    }

    QLOG_ERROR() << "Open failed : " << file.fileName();

    return false;
}

void orderprintwork::MapToString(const QVariantMap map, QString &config)
{
    QJsonObject json = QJsonObject::fromVariantMap(map);

    config = QString(QJsonDocument(json).toJson(QJsonDocument::Compact));
}

void orderprintwork::DoPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag)
{
    QString strconfig;
    QString context;
    OrderObject order;

    QLOG_DEBUG() << "PosOrderPool::GetOrderObject::orderid" << orderid;

    if(!PosOrderPool::GetOrderObject(orderid, order))
    {
        QLOG_ERROR() << "orderprintwork::DoPrint::PosOrderPool::GetOrderObject failed";
        return ;
    }

    MapToString(config, strconfig);

    int page = config[PRT_CONF_PAPERWIDTH].toString().toInt();

    if(page == 0)
        page = 56;

    if(!GetPrtTemplet(0, page, context, order))
    {
        QLOG_ERROR() << "orderprintwork::DoPrint::GetPrtTemplet failed";
        return ;
    }

    flag = NewPrintLib::GetInstance().DoPrint(strconfig, context, &order, page);

    QLOG_DEBUG() << "NewPrintLib::GetInstance flag : " << flag;
}

void orderprintwork::DoLabelPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag)
{
    QString strconfig;
    OrderObject order;
    QString context;

    if(!PosOrderPool::GetOrderObject(orderid, order))
    {
        QLOG_ERROR() << "orderprintwork::DoPrint::PosOrderPool::GetOrderObject failed";
        return ;
    }

    MapToString(config, strconfig);

    QLOG_DEBUG() << "strconfig:" << strconfig;

    int page = config[PRT_CONF_PAPERWIDTH].toString().toInt();

    if(page == 0)
        page = 56;

    if(!GetPrtTemplet(1, page, context, order))
    {
        QLOG_ERROR() << "orderprintwork::DoLabelPrint::GetPrtTemplet failed";
        return ;
    }

//    flag = NewPrintLib::GetInstance().DoLabelPrint(strconfig, &order);
    flag = NewPrintLib::GetInstance().DoLabelModelPrint(strconfig, context, &order);

    QLOG_DEBUG() << "DoLabelPrint NewPrintLib::GetInstance flag : " << flag;
}

void orderprintwork::ResultShow(const QString &orderid, bool flag)
{
    if(flag)
    {
        QLOG_INFO() << "print succcess";

        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, true);
        tmpmap.insert(EVENT_KEY_MSG, QString(orderid).append(QString::fromUtf8("\xE6\x89\x93\xE5\x8D\xB0\xE6\x88\x90\xE5\x8A\x9F")));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);

        QVariantMap maps;

        maps.insert(EVENT_KEY_ORDERID, orderid);
        maps.insert(EVENT_KEY_MSG, DEFAULT_LOCATION_PRINT);
        maps.insert(EVENT_KEY_STATUS, 1);

        POSTEVENTTYPE(PosEvent::s_location_orderpool,maps,QVariantMap);
    }
    else
    {
        QLOG_DEBUG() << "print failed : " << orderid;

        QVariantMap tmpmap;

        tmpmap.insert(EVENT_KEY_STATUS, false);
        tmpmap.insert(EVENT_KEY_MSG, QString(orderid).append(QString::fromUtf8("\x20\xE6\x89\x93\xE5\x8D\xB0\xE5\xA4\xB1\xE8\xB4\xA5")));

        POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
    }
}

void orderprintwork::DoBackPrint(const QString &prtname, const QString &orderid, const QVariantMap config, bool &flag)
{
    QString strconfig;
    QString context;
    OrderObject order;
    QString stallsid;
    QStringList prodlist;
    int pagenum = 0, pagedepart = 0, proddeprat = 0;

    if(!PosOrderPool::GetOrderObject(orderid, order))
    {
        QLOG_ERROR() << "orderprintwork::DoBackPrint::PosOrderPool::GetOrderObject failed";
        return ;
    }

    MapToString(config, strconfig);

    int page = config[PRT_CONF_PAPERWIDTH].toString().toInt();

    if(page == 0)
        page = 56;

    if(!GetPrtTemplet(2, page, context, order))
    {
        QLOG_ERROR() << "orderprintwork::DoBackPrint::GetPrtTemplet failed";
        return ;
    }

    if(!PosPrtPool::GetPrtStalls(prtname, stallsid))
    {
        QLOG_ERROR() << "orderprintwork::DoBackPrint::PosPrtPool::GetPrtStalls failed";
        //后厨打印机没有配置档口当作打印成功;
        flag = true;
        return ;
    }

    if(!PosStallsPool::GetProdIDList(stallsid, prodlist))
    {
        QLOG_ERROR() << "orderprintwork::DoBackPrint::PosStallsPool::GetProdIDList failed";
        return ;
    }

    if(!PosStallsPool::GetStallsArgv(stallsid, pagedepart, proddeprat, pagenum))
    {
        QLOG_ERROR() << "orderprintwork::DoBackPrint::PosStallsPool::GetStallsArgv failed";
        return ;
    }

    flag = NewPrintLib::GetInstance().DoBackPrint(pagedepart, proddeprat, pagenum, prodlist, strconfig, context, &order, page);
}

//bool orderprintwork::event(QEvent *e)
//{
//    if(e->type() == PosEvent::s_order_location)
//    {
//        QVariantMap map;

//        GETEVENTINFO(map, e, QVariantMap);

//        if(map.contains(EVENT_KEY_ORDERID) && map.contains(EVENT_KEY_MSG) &&
//                map[EVENT_KEY_MSG].toInt() == DEFAULT_LOCATION_PRINT)
//        {

////            QVariantMap smap;
////            smap.insert(EVENT_KEY_ORDERSTATUS, 0);
////            smap.insert(EVENT_KEY_MSG, QString::fromLocal8Bit("打印中..."));
////            POSTEVENTTYPE(PosEvent::s_opt_status,smap,QVariantMap);

//            OrderObject order;

//            PosOrderPool::GetOrderObject(map[EVENT_KEY_ORDERID].toString(), order);

//            QLOG_INFO() << "begin print ...";

//            QString error;
//            QString content;

//            //QFile file(qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET);
//            QFile file;

//            QString prtinifile = qApp->applicationDirPath() + "/" + PREINTER_CONSS;

//            int prtwi = QSettings(prtinifile, QSettings::IniFormat).value("Printer/PaperWidth", 0).toInt();

//            if(QString("saas").compare(order.channel, Qt::CaseInsensitive) == 0)
//            {
//                if(order.order_type == 1 || order.order_type == 2)
//                {
//                    if(prtwi <= 56)
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTTAKE_TEMPLET);
//                    else
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTTAKE80_TEMPLET);
//                }
//                else if(order.order_type == 6)
//                {
//                    if(prtwi <= 56)
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTYY_TEMPLET);
//                    else
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTYY80_TEMPLET);
//                }
//                else
//                {
//                    if(prtwi <= 56)
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET);
//                    else
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT80_TEMPLET);
//                }
//            }
//            else
//            {
//                if(order.order_type == 1 || order.order_type == 2)
//                {
//                    if(prtwi <= 56)
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2O_TEMPLET);
//                    else
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2O80_TEMPLET);
//                }
//                else
//                {
//                    if(prtwi <= 56)
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2OZZ_TEMPLET);
//                    else
//                        file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2OZZ80_TEMPLET);
//                }
//            }


//            qDebug() << "+++++++++++++++++++++++++++" << file.fileName();

//            if(!file.open(QFile::ReadOnly))
//            {
//                QVariantMap tmpmap;

//                tmpmap.insert(EVENT_KEY_STATUS, false);
//                tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit(" 打印失败")));

//                POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);

//                QLOG_ERROR() << "open " << qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET << " failed";
//                return true;
//            }

//            content = QString::fromUtf8(file.readAll());
//            file.close();

//            qDebug() << content;
//            {
//                PrintLib print;

//                if(print.DoPrint(content, &order, error))
//                {
//                    QLOG_INFO() << "print succcess";

//                    QVariantMap tmpmap;

//                    tmpmap.insert(EVENT_KEY_STATUS, true);
//                    tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit("打印成功")));

//                    POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);

//                    QVariantMap map;

//                    map.insert(EVENT_KEY_ORDERID, order.order_id);
//                    map.insert(EVENT_KEY_MSG, DEFAULT_LOCATION_PRINT);
//                    map.insert(EVENT_KEY_STATUS, 1);

//                    POSTEVENTTYPE(PosEvent::s_location_orderpool,map,QVariantMap);
//                }
//                else
//                {
//                    QLOG_INFO() << "print failed : " << error;

//                    QVariantMap tmpmap;

//                    tmpmap.insert(EVENT_KEY_STATUS, false);
//                    tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit(" 打印失败")));

//                    POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);

//                }
//            }
//            QString otherfile = qApp->applicationDirPath() + "/" + PREINTER_CONSS;
//            QString tmpotherfile = qApp->applicationDirPath() + "/" + PREINTER_NEED;

//            int needptr = QSettings(tmpotherfile, QSettings::IniFormat).value(INI_NEEDPTR, 0).toInt();


//            QEventLoop loop;
//            QTimer timer;

//            connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);

//            timer.start(2*1000);

//            loop.exec();

//            if(needptr == 1)
//            {
//                PrintLib otherprint;

//                QVariantMap smap;
//                smap.insert(EVENT_KEY_ORDERSTATUS, 0);
//                smap.insert(EVENT_KEY_MSG, QString::fromLocal8Bit("打印中..."));
//                POSTEVENTTYPE(PosEvent::s_opt_status,smap,QVariantMap);

//                QString error;
//                QString contents;

//                //QFile file(qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET);
//                QFile file;

//                int othprtw = QSettings(prtinifile, QSettings::IniFormat).value("OtherPrinter/PaperWidth", 0).toInt();
//                if(QString("saas").compare(order.channel, Qt::CaseInsensitive) == 0)
//                {
//                    if(order.order_type == 1 || order.order_type == 2)
//                    {
//                        if(othprtw <= 56)
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTTAKE_TEMPLET);
//                        else
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTTAKE80_TEMPLET);
//                    }
//                    else if(order.order_type == 6)
//                    {
//                        if(othprtw <= 56)
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTYY_TEMPLET);
//                        else
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTYY80_TEMPLET);
//                    }
//                    else
//                    {
//                        if(othprtw <= 56)
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET);
//                        else
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINT80_TEMPLET);
//                    }
//                }
//                else
//                {
//                    if(order.order_type == 1 || order.order_type == 2)
//                    {
//                        if(prtwi <= 56)
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2O_TEMPLET);
//                        else
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2O80_TEMPLET);
//                    }
//                    else
//                    {
//                        if(prtwi <= 56)
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2OZZ_TEMPLET);
//                        else
//                            file.setFileName(qApp->applicationDirPath() + "/" + FILE_PRINTO2OZZ80_TEMPLET);
//                    }
//                }

//                qDebug() << "+++++++++++++++++++++++++++" << file.fileName();

//                if(!file.open(QFile::ReadOnly))
//                {
//                    QVariantMap tmpmap;

//                    tmpmap.insert(EVENT_KEY_STATUS, false);
//                    tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit(" 打印失败")));

//                    POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);

//                    QLOG_ERROR() << "open " << qApp->applicationDirPath() + "/" + FILE_PRINT_TEMPLET << " failed";
//                    return true;
//                }

//                contents = QString::fromUtf8(file.readAll());
//                file.close();

//                if(otherprint.OnlyDoPrint(contents, &order, error, true))
//                {
//                    QLOG_INFO() << "print succcess";

//                    QVariantMap tmpmap;

//                    tmpmap.insert(EVENT_KEY_STATUS, true);
//                    tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit("打印成功")));

//                    POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
//                }
//                else
//                {
//                    QLOG_INFO() << "print failed : " << error;

//                    QVariantMap tmpmap;

//                    tmpmap.insert(EVENT_KEY_STATUS, false);
//                    tmpmap.insert(EVENT_KEY_MSG, QString(order.order_id).append(QString::fromLocal8Bit(" 打印失败")));

//                    POSTEVENTTYPE(PosEvent::s_opt_status,tmpmap,QVariantMap);
//                }
//            }
//        }
//        return true;
//    }

//    return WorkObject::event(e);
//}

