#include "orderlocalizework.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "model/posorderpool.h"
#include "preDefine.h"
#include "base/DB/fm_database.h"
#include "QsLog.h"
#include <QString>
#include <QVariantMap>
#include <QSqlQuery>
#include <QStringList>

OrderLocalizeWork::OrderLocalizeWork(WorkObject *parent) : WorkObject(parent)
{
    //订单状态改变更新db
    FMApplication::subscibeEvent(this, PosEvent::s_change_order);
    //订单改变删除db
    FMApplication::subscibeEvent(this, PosEvent::s_delete_order);
    //订单本地状态改变更新db
    FMApplication::subscibeEvent(this, PosEvent::s_opt_change_order);

    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_DBNAME);

    db.creat(QString("create table orderlist (order_id varchar(40) primary key,"
                     "order_write_status int(1),order_refund_status int(1),order_print_status "
                     "int(1),reserved1 varchar(40),reserved2 varchar(40),reserved3 varchar(40),"
                     "reserved4 varchar(40),reserved5 varchar(40),order_change_time varchar(20))"), DEFAULT_DBFORM);
}

bool OrderLocalizeWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_order || e->type() == PosEvent::s_opt_change_order)
    {
        QString orderid;

        GETEVENTINFO(orderid,e,QString);

        QLOG_DEBUG() << "otpOrder failed";

        otpOrder(orderid);

        return true;
    }

    if(e->type() == PosEvent::s_delete_order)
    {
        QVariantMap value;

        GETEVENTINFO(value,e,QVariantMap);

        if(value.contains(EVENT_KEY_ORDERID))
            deleteOrder(value[EVENT_KEY_ORDERID].toString());

        return true;
    }

    return WorkObject::event(e);
}

void OrderLocalizeWork::deleteOrder(QString orderid)
{
    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_DBNAME);

    QSqlQuery query;

    QStringList list;
    list.append(EVENT_KEY_ORDERID);

    if(!db.find(DEFAULT_DBFORM, query, list, QString(DB_KEY_ORDERID).append("='%1'").arg(orderid)))
        return ;

    if(!query.next())
    {
        QLOG_WARN() << "not found order : " << orderid;
        return ;
    }
    else
    {
        bool flag = db.dlt(DEFAULT_DBFORM, QString(DB_KEY_ORDERID).append("='%1'").arg(orderid));
        QLOG_DEBUG() << "delete order : " << orderid << "(" << flag << ")";
    }
}

void OrderLocalizeWork::otpOrder(QString orderid)
{
    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_DBNAME);

    QSqlQuery query;

    QStringList list;
    list.append(EVENT_KEY_ORDERID);

    if(!db.find(DEFAULT_DBFORM, query, list, QString(DB_KEY_ORDERID).append("='%1'").arg(orderid)))
        return ;

    QVariantHash hash;

    if(!PosOrderPool::GetOrderBaseInfo(orderid, hash))
    {
        QLOG_ERROR() << "GetOrderBaseInfo failed : " << orderid;
        return ;
    }

    if(!query.next())
    {        
        QLOG_DEBUG() << "insert new order" << hash;
        bool flag = db.insert(DEFAULT_DBFORM, hash);
        QLOG_DEBUG() << "insert new order : " << orderid << "(" << flag << ")";
    }
    else
    {
        //订单最后改变时间要同步到db
        QLOG_DEBUG() << "update order" << hash;
        bool flag = db.update(DEFAULT_DBFORM, hash, QString(DB_KEY_ORDERID).append("='%1'").arg(orderid));
        QLOG_DEBUG() << "update order : " << orderid << "(" << flag << ")";
    }
}

