#ifndef ORDERENTRYWORK_H
#define ORDERENTRYWORK_H

#include "control/workobject.h"
#include "view/alertForm.h"
#include "model/productObject.h"
#include "model/orderObject.h"

#include <QtSql/QtSql>

//struct XSJBXX_DATA{
//    QString   BZ;
//    QString   XSDH;
//    QString   XH;
//    QString   DDYBH;
//    double    JEZJ;
//    double    ZKJE;
//    double    ZRJE;
//    double    YS;
//    double    SS;
//    QDateTime DDSJ;
//    QDateTime JYSJ;
//    QString   JZFSBM;
//    QString   ZH;
//    QString   KHBH;
//    double    QKJE;
//    int       WMBS;
//    QString   BY7;
//    int       JCRS;
//};

//struct XSMXXX_DATA{
//    QString XH;
//    QString XSDH;
//    QString XMBH;
//    QString XMMC;
//    QString TM;
//    QString DW;
//    double  YSJG;
//    double  XSJG;
//    double  SL;
//    double  XSJEXJ;
//    double  FTJE;
//    QString SYYXM;
//    QString SSLBBM;
//    QString SFXS;
//};

//struct XSFKFS_DATA{
//    long    XH;
//    QString XSDH;
//    QString BM;
//    QString NR;
//    double  FKJE;
//    int     DYQZS;
//};

class OrderEntryWork : public WorkObject
{
    Q_OBJECT
public:
    explicit OrderEntryWork(WorkObject *parent = 0);

    virtual bool event(QEvent *e);

private:

    //连接数据库
    bool openDatabase();

    //订单入机
    void orderInput(QString orderid);

    //通过商品名称获取项目编号
    QString getLBBM(QString XMBH);

    QString getXMBH(QString LBBM);

    QString getXMMC(QString LBBM);

    QString getTM(QString LBBM);

    QString getDW(QString XMBH);

    bool isInserted(QString fm_id);

    bool XHisExisted();

    bool insertYHJBQKtable(QString pl, QString platform);


    //插入消费基本信息表
    bool insertXSJBXXtable(OrderObject order, QString &error);
    //插入消费明细表
    bool insertXSMXXXtable(OrderObject order, QString &error);
    //插入销售付款方式表
    bool insertXSFKFStable(OrderObject order, QString &error);

private:

    QSqlDatabase m_db;

    int m_index;

    QString m_partnerid;
};


#endif // ORDERENTRYWORK_H
