﻿#include "orderentrywork.h"
#include "QsLog.h"
#include "view/alertForm.h"
#include "model/posorderpool.h"
#include "model/orderObject.h"
#include "model/productObject.h"
#include "base/DB/fm_database.h"
#include "preDefine.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include <QtSql/QtSql>

OrderEntryWork::OrderEntryWork(WorkObject *parent) : WorkObject(parent)
{

    QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    int num = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_SERIAL).toInt();
    m_index = num % 200000000;

    //将开个店新增平台插入YHJBQK表，先判断是否已经存在，存在不插入，不存在则插入

//    m_db = QSqlDatabase::addDatabase("QODBC");
//    m_db.setDatabaseName(QString("DRIVER={SQL SERVER};"
//                               "SERVER=%1;" //服务器名称
//                               "DATABASE=%2;"//数据库名
//                               "UID=%3;"           //登录名
//                               "PWD=%4;"        //密码
//                               )
//                       .arg("SH-FM")
//                       .arg("GSCYDB")
//                       .arg("sa")
//                       .arg("Sy0592")
//                       );
//    QString dsn = QString::fromLocal8Bit("GSCYDB");
//    m_db.setHostName("SH-FM");
//    m_db.setDatabaseName(dsn);
//    m_db.setUserName("sa");
//    m_db.setPassword("Sy0592");

//    if (!m_db.open())
//    {
//        QLOG_ERROR()<<"connect sql server failed!" << m_db.lastError().databaseText();
//    }
//    else
//    {
//        QLOG_DEBUG()<<"connect sql server successfully!";
//        QLOG_DEBUG() << m_db.isValid();
//    }

    FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_ENRTYFAILED);

    db.creat(QString("create table entryfailedlist (order_id varchar(40) primary key,"
                     "order_entryfailed_dec varchar(200))"), DEFAULT_ENRTYFAILEDFORM);

    FMApplication::subscibeEvent(this, PosEvent::s_change_order);
    FMApplication::subscibeEvent(this, PosEvent::s_opt_change_order);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);

//    QString serverName = "DCKRSHW5HQU8SM1\\SQLEXPRESS";
//    QString dbName = "test";
//    QSqlDatabase myDB = QSqlDatabase::addDatabase("QODBC");//连接到ODBC驱动
//    QString dsn = QString("Driver={SQL Server};Server=%1;Database=%2;Trusted_Connection=yes").arg(serverName).arg(dbName);
//    myDB.setDatabaseName(dsn);
//    if(myDB.open())
//    {
//        printf("connect to server successfully\n");
//        myDB.close();
//    }
//    else
//    {
//        printf("connect to server failed\n");
//        printf("%s\n",myDB.lastError().text().toLatin1().data());
    //    }
}

bool OrderEntryWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_change_order || e->type() == PosEvent::s_opt_change_order)
    {
        QString orderid;

        GETEVENTINFO(orderid,e,QString);

        QLOG_DEBUG() << "event received" << orderid << m_partnerid;

        OrderObject order;
        int status = DefaultOrder, refund_status = DefaultOrder;
        bool oldorder;
        PosOrderPool::GetOrderStatus(orderid,status,refund_status,oldorder);
        if(PosOrderPool::GetOrderObject(orderid, order)) {
            if(m_partnerid == "2055") {           //书亦的商户号，目前只有书亦需要入机
                QLOG_DEBUG()<<"start orderentrywork!";
                if((status == CompleteOrder || status == ServiceOrder) &&
                        !(refund_status == ApplicationRefundOrder || refund_status == ApplicationPartialRefundOrder)) {

                    orderInput(orderid);
                }
            }
        }

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap map;

        GETEVENTINFO(map, e, QVariantMap);

        m_partnerid = map[JSON_KEY_PARTNERID].toString();

        return true;
    }

    return WorkObject::event(e);
}

bool OrderEntryWork::openDatabase()
{
//    QSqlDatabase db=QSqlDatabase::addDatabase("QODBC");
//    db.setDatabaseName(QString("DRIVER={SQL SERVER};"
//                               "SERVER=%1;" //服务器名称
//                               "DATABASE=%2;"//数据库名
//                               "UID=%3;"           //登录名
//                               "PWD=%4;"        //密码
//                               )
//                       .arg("202.0.0.0")
//                       .arg("name")
//                       .arg("username")
//                       .arg("password")
//                       );
//    if (!m_db.open())
//    {
//        QLOG_ERROR()<<"connect sql server failed!" << m_db.lastError().databaseText();
//        return false;
//    }
//    else
//    {
//        QLOG_DEBUG()<<"connect sql server successfully!";
//        return true;
//    }

    return true;

}

void OrderEntryWork::orderInput(QString orderid)
{
    OrderObject order;
    if(!PosOrderPool::GetOrderObject(orderid, order))
        return ;
//    QList<ProductObject *> products = order.proList;
//    QLOG_DEBUG() << "products.size = " <<products.size();

    m_db = QSqlDatabase::addDatabase("QODBC");
    m_db.setDatabaseName(QString("DRIVER={SQL SERVER};"
                               "SERVER=%1;"         //服务器名称
                               "DATABASE=%2;"       //数据库名
                               "UID=%3;"            //登录名
                               "PWD=%4;"            //密码
                               )
                       .arg("127.0.0.1")
                       .arg("GSCYDB")
                       .arg("sa")
                       .arg("dream0592way")
                       );
//    QString dsn = QString::fromLocal8Bit("GSCYDB");
//    m_db.setHostName("SH-FM");
//    m_db.setDatabaseName(dsn);
//    m_db.setUserName("sa");
//    m_db.setPassword("Sy0592");

    if (!m_db.open())
    {
        //重试密码，两次都不正确退出，并报错
        m_db = QSqlDatabase::addDatabase("QODBC");
        m_db.setDatabaseName(QString("DRIVER={SQL SERVER};"
                                   "SERVER=%1;"         //服务器名称
                                   "DATABASE=%2;"       //数据库名
                                   "UID=%3;"            //登录名
                                   "PWD=%4;"            //密码
                                   )
                           .arg("127.0.0.1")
                           .arg("GSCYDB")
                           .arg("sa")
                           .arg("peggy032")
                           );
        if (!m_db.open()) {
            QLOG_ERROR()<<"connect sql server failed!" << m_db.lastError().databaseText();
            return;
        }
    }

    //插入新增平台，如果存在，数据库报错不会重新插入
    insertYHJBQKtable(QString("BD"), QString::fromLocal8Bit(XSJBXX_DDYBH_BD));
    insertYHJBQKtable(QString("JDDJ"), QString::fromLocal8Bit(XSJBXX_DDYBH_JDDJ));
    insertYHJBQKtable(QString("SAAS"), QString::fromLocal8Bit(XSJBXX_DDYBH_SAAS));

    if(isInserted(order.order_id))
    {
        QLOG_DEBUG() << order.order_id << "is inserted!";
        return;
    }
    m_db.transaction();

    QString error1;QString error2;QString error3;

    QLOG_DEBUG()<<"connect sql server successfully!";
    QLOG_DEBUG() << m_db.isValid();


    //消费基本信息、消费明细表、销售付款方式表
    if(insertXSFKFStable(order,error1) && insertXSJBXXtable(order,error2)
            && insertXSMXXXtable(order,error3)) {
        //入机成功
        QLOG_DEBUG() << QString::fromLocal8Bit("入机成功");
        m_db.commit();
    } else {
        //入机失败，回滚表数据，并插入临时表做记录
        QLOG_DEBUG() << QString::fromLocal8Bit("入机失败，回滚表数据，并插入临时表做记录");
        QString error = QString("XSFKFS error:") + error1 + QString("/XSJBXX error:") + error2 + QString("/XSMXXX error:") + error3;
        QLOG_DEBUG() << "orderinsert error info:" << error;

        QVariantMap map;
        map.insert("order_id", order.order_id);
        map.insert("order_entryfailed_dec", error);
        QLOG_DEBUG() << "error msg :" << map;

        FMDataBase db(qApp->applicationDirPath() + "/" + DEFAULT_ENRTYFAILED);
        bool flag = db.insert(DEFAULT_ENRTYFAILEDFORM, map);
        QLOG_DEBUG() << "insert tmp sqlite db result :" << flag;

        m_db.rollback();
    }

//    }

}

QString OrderEntryWork::getLBBM(QString XMBH)
{
    QSqlQuery query;
    QString str = QString("SELECT LBBM FROM JYXMSZ WHERE XMBH = '%1'").arg(XMBH);
    bool res = query.exec(str);
    QLOG_DEBUG() << "OrderEntryWork::getLBBM" <<str << res;
    if(res) {
        while(query.next()) {
            return query.value(0).toString();
        }
        return "";
    } else {
        return "";
    }

}

QString OrderEntryWork::getXMBH(QString LBBM)
{
    QSqlQuery query;
    QString str = QString("SELECT XMBH FROM JYXMSZ WHERE LBBM = %1").arg(LBBM);
    bool res = query.exec(str);
    if(res) {
        while(query.next()) {
            return query.value(0).toString();
        }
    } else {
        return "";
    }
}

QString OrderEntryWork::getXMMC(QString LBBM)
{
    QSqlQuery query;
    QString str = QString("SELECT XMMC FROM JYXMSZ WHERE LBBM = %1").arg(LBBM);
    bool res = query.exec(str);
    if(res) {
        while(query.next()) {
            return query.value(0).toString();
        }
    } else {
        return "";
    }
}

QString OrderEntryWork::getTM(QString LBBM)
{
    QSqlQuery query;
    QString str = QString("SELECT TM FROM JYXMSZ WHERE LBBM = %1").arg(LBBM);
    bool res = query.exec(str);
    if(res) {
        while(query.next()) {
            return query.value(0).toString();
        }
    } else {
        return "";
    }
}

QString OrderEntryWork::getDW(QString XMBH)
{
    QSqlQuery query;
    QString str = QString("SELECT DW FROM JYXMSZ WHERE XMBH = '%1'").arg(XMBH);
    bool res = query.exec(str);
    QLOG_DEBUG() << "OrderEntryWork::getLBBM" <<str << res;
    if(res) {
        while(query.next()) {
            return QString::fromUtf8(query.value(0).toByteArray());
        }
        return "";
    } else {
        return "";
    }
}

bool OrderEntryWork::isInserted(QString order_id)
{
    QSqlQuery query;
    QString str = QString("SELECT * FROM XSJBXX WHERE XSDH = '%1'").arg(order_id);
    QLOG_DEBUG() << "OrderEntryWork::isInserted sql str:" << str;
    bool res = query.exec(str);
    QLOG_DEBUG() << res;
    if(res) {
        return query.next();
        QLOG_DEBUG() << query.next();
    }
    return false;
}

bool OrderEntryWork::XHisExisted()
{
    QSqlQuery query;
    QString str = QString("SELECT * FROM YHJBQK WHERE YHBH = 'SAAS'");
    QLOG_DEBUG() << "OrderEntryWork::SAAS is existed:" << str;
    bool res = query.exec(str);
    QLOG_DEBUG() << res;
    if(res) {
        return query.next();
        QLOG_DEBUG() << query.next();
    }
    return false;
}

bool OrderEntryWork::insertYHJBQKtable(QString pl,QString platform)
{
    QSqlQuery query;
    QString str = QString("INSERT INTO [dbo].[YHJBQK] (YHBH,YHMC) VALUES ('%1','%2');").arg(pl).arg(platform);
    QLOG_DEBUG() << "OrderEntryWork::insertYHJBQKtable sql str:" << str;
    bool res = query.exec(str);
    QLOG_DEBUG() << res;
    if(res) {
        return query.next();
        QLOG_DEBUG() << "OrderEntryWork::insertYHJBQKtable :" << query.next();
    }
    QLOG_DEBUG() << "OrderEntryWork::insertYHJBQKtable :" << res;
    return false;
}

bool OrderEntryWork::insertXSJBXXtable(OrderObject order, QString &error)
{
    QString BZ = "POS";
    QString XSDH = order.order_id;
    QString channel = order.channel;
    QString XH;
    QString DDYBH;
    QString BY7;
    if(channel == "mt") {
        XH = "MT";
        DDYBH = QString::fromLocal8Bit(XSJBXX_DDYBH_MT);
        BY7 = QString::fromLocal8Bit(XSJBXX_BY7_MT) + order.order_id;
    } else if(channel == "elm") {
        XH = "ELM";
        DDYBH = QString::fromLocal8Bit(XSJBXX_DDYBH_ELM);
        BY7 = QString::fromLocal8Bit(XSJBXX_BY7_ELM) + order.order_id;
    } else if(channel == "bd") {
        XH = "BD";
        DDYBH = QString::fromLocal8Bit(XSJBXX_DDYBH_BD);
        BY7 = QString::fromLocal8Bit(XSJBXX_BY7_BD) + order.order_id;
    } else if(channel == "jddj") {
        XH = "JDDJ";
        DDYBH = QString::fromLocal8Bit(XSJBXX_DDYBH_JDDJ);
        BY7 = QString::fromLocal8Bit(XSJBXX_BY7_JDDJ) + order.order_id;
    } else if(channel == "saas") {
        XH = "SAAS";
        DDYBH = QString::fromLocal8Bit(XSJBXX_DDYBH_SAAS);
        BY7 = QString::fromLocal8Bit(XSJBXX_BY7_SAAS) + order.order_id;
    }

    double JEZJ = order.total_fee/100.00;     //订单总额
    double ZKJE = 0;
    double ZRJE = 0;
    double YS = (order.total_fee - order.discount_fee)/100.00;    //扣减优惠金额后的金额
    double SS = 0;
    QDateTime DDSJ = QDateTime::fromTime_t(order.create_time);
    QDateTime JYSJ = QDateTime::fromTime_t(order.create_time);
    QString JZFSBM = QString::fromLocal8Bit(WAISONG);
    QString ZH = QString::number(order.order_index);
    QString KHBH = "0";
    double QKJE = 0;
    int WMBS = order.order_index;
    int JCRS = 1;

    QSqlQuery query;
    QString str = QString("INSERT INTO XSJBXX (BZ,XSDH,XH,DDYBH,JEZJ,ZKJE"
                          ",ZRJE,YS,SS,DDSJ,JYSJ,JZFSBM,ZH,KHBH,QKJE,WMBS,BY7,JCRS) VALUES ("
                          "'%1','%2','%3','%4',%5,%6,%7,%8,%9,'%10','%11','%12','%13','%14',%15,%16,'%17',%18);")
            .arg(BZ).arg(XSDH).arg(XH).arg(DDYBH).arg(JEZJ).arg(ZKJE).arg(ZRJE)
            .arg(YS).arg(SS).arg(DDSJ.toString("yyyy-MM-dd hh:mm:ss")).arg(JYSJ.toString("yyyy-MM-dd hh:mm:ss")).arg(JZFSBM).arg(ZH).arg(KHBH)
            .arg(QKJE).arg(WMBS).arg(BY7).arg(JCRS);
    QLOG_DEBUG() << "OrderEntryWork::insertXSJBXXtable:" << str;
    bool res = query.exec(str);
    if(!res) {
        error = query.lastError().databaseText();
        QLOG_ERROR() << "insertXSJBXXtable error:" << error;
    }
    return res;

}

bool OrderEntryWork::insertXSMXXXtable(OrderObject order,QString &error)
{
    bool res = true;

    QList<ProductObject *> products = order.proList;
    QLOG_DEBUG() << "OrderEntryWork::insertXSMXXXtable" << products.size();
    for(int i = 0; i < products.size(); i++) {
        ProductObject * product = products.at(i);
        QLOG_DEBUG() << "OrderEntryWork::insertXSMXXXtable" << product->pid;

        QString XH = order.order_id + QString("_") + QString::number(m_index);
        QString XSDH = order.order_id;
        QString XMBH = product->product_code;
        QString XMMC = product->name;
        QString TM = product->product_code;
        QString DW = getDW(XMBH);
        double  YSJG = product->price/100.00;
        double  XSJG = product->price/100.00;
        double  SL = product->product_amount;
        double  XSJEXJ = product->price/100.00;
        double  FTJE = product->price/100.00;
        QString SYYXM;

        QString channel = order.channel;
        if(channel == "mt") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_MT);
        } else if(channel == "elm") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_ELM);
        } else if(channel == "bd") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_BD);
        } else if(channel == "jddj") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_JDDJ);
        } else if(channel == "saas") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_SAAS);
        }

        QString SSLBBM = getLBBM(XMBH);
        QLOG_DEBUG() << "INSERT XSMXXX TABLE" << SSLBBM;
        QString SFXS = "1";


        QSqlQuery query;
        QString str = QString("INSERT INTO XSMXXX (XH,XSDH,XMBH,XMMC,TM,DW"
                              ",YSJG,XSJG,SL,XSJEXJ,FTJE,SYYXM,SSLBBM,SFXS) VALUES ("
                              "'%1','%2','%3','%4','%5','%6',%7,%8,%9,%10,%11,'%12','%13','%14');")
                .arg(XH).arg(XSDH).arg(XMBH).arg(XMMC).arg(TM).arg(DW).arg(YSJG)
                .arg(XSJG).arg(SL).arg(XSJEXJ).arg(FTJE).arg(SYYXM).arg(SSLBBM).arg(SFXS);
        QLOG_DEBUG() << "OrderEntryWork::insertXSMXXXtable:" << str;
        bool flag = query.exec(str);
        if(!flag) {
            error = query.lastError().databaseText() + "/" + product->name;
            QLOG_ERROR() << "insertXSMXXXtable error:" << error;
            res = false;
            return res;
        }
        m_index++;
        QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
        QSettings(configfile, QSettings::IniFormat).setValue(INI_BASE_SERIAL, m_index);
    }

    //餐盒费以单品入机
    if(order.package_fee != 0) {
        QString XH = order.order_id + QString("_") + QString::number(m_index);
        QString XSDH = order.order_id;
        QString XMBH = "JH002";
        QString XMMC = QString::fromLocal8Bit(XSMXXX_JH002);
        QString TM = "JH002";
        double  YSJG = order.package_fee/100.00;
        double  XSJG = order.package_fee/100.00;
        double  SL = 1;
        double  XSJEXJ = order.package_fee/100.00;
        double  FTJE = order.package_fee/100.00;
        QString SYYXM;

        QString channel = order.channel;
        if(channel == "mt") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_MT);
        } else if(channel == "elm") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_ELM);
        } else if(channel == "bd") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_BD);
        } else if(channel == "jddj") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_JDDJ);
        } else if(channel == "saas") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_SAAS);
        }

        QString SSLBBM = "JH";
        QLOG_DEBUG() << "INSERT XSMXXX TABLE" << SSLBBM;
        QString SFXS = "1";

        QSqlQuery query;
        QString str = QString("INSERT INTO XSMXXX (XH,XSDH,XMBH,XMMC,TM"
                              ",YSJG,XSJG,SL,XSJEXJ,FTJE,SYYXM,SSLBBM,SFXS) VALUES ("
                              "'%1','%2','%3','%4','%5',%6,%7,%8,%9,%10,'%11','%12','%13');")
                .arg(XH).arg(XSDH).arg(XMBH).arg(XMMC).arg(TM).arg(YSJG)
                .arg(XSJG).arg(SL).arg(XSJEXJ).arg(FTJE).arg(SYYXM).arg(SSLBBM).arg(SFXS);
        QLOG_DEBUG() << "OrderEntryWork::package_fee insertXSMXXXtable:" << str;
        bool flag = query.exec(str);
        if(!flag) {
            error = query.lastError().databaseText() + "/" + order.order_id;
            QLOG_ERROR() << "package_fee insertXSMXXXtable error:" << error;
            res = false;
            return res;
        }
        m_index++;
        QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
        QSettings(configfile, QSettings::IniFormat).setValue(INI_BASE_SERIAL, m_index);
    }

    //如果配送费不为空，则将配送费入机
    if(order.send_fee != 0) {
        QString XH = order.order_id + QString("_") + QString::number(m_index);
        QString XSDH = order.order_id;
        QString XMBH = "JH001";
        QString XMMC = QString::fromLocal8Bit(XSMXXX_JH001);
        QString TM = "JH001";
        double  YSJG = order.send_fee/100.00;
        double  XSJG = order.send_fee/100.00;
        double  SL = 1;
        double  XSJEXJ = order.send_fee/100.00;
        double  FTJE = order.send_fee/100.00;
        QString SYYXM;

        QString channel = order.channel;
        if(channel == "mt") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_MT);
        } else if(channel == "elm") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_ELM);
        } else if(channel == "bd") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_BD);
        } else if(channel == "jddj") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_JDDJ);
        } else if(channel == "saas") {
            SYYXM = QString::fromLocal8Bit(XSJBXX_DDYBH_SAAS);
        }

        QString SSLBBM = "JH";
        QLOG_DEBUG() << "INSERT XSMXXX TABLE" << SSLBBM;
        QString SFXS = "1";

        QSqlQuery query;
        QString str = QString("INSERT INTO XSMXXX (XH,XSDH,XMBH,XMMC,TM"
                              ",YSJG,XSJG,SL,XSJEXJ,FTJE,SYYXM,SSLBBM,SFXS) VALUES ("
                              "'%1','%2','%3','%4','%5',%6,%7,%8,%9,%10,'%11','%12','%13');")
                .arg(XH).arg(XSDH).arg(XMBH).arg(XMMC).arg(TM).arg(YSJG)
                .arg(XSJG).arg(SL).arg(XSJEXJ).arg(FTJE).arg(SYYXM).arg(SSLBBM).arg(SFXS);
        QLOG_DEBUG() << "OrderEntryWork::send_fee insertXSMXXXtable:" << str;
        bool flag = query.exec(str);
        if(!flag) {
            error = query.lastError().databaseText() + "/" + order.order_id;
            QLOG_ERROR() << "send_fee insertXSMXXXtable error:" << error;
            res = false;
            return res;
        }
        m_index++;
        QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
        QSettings(configfile, QSettings::IniFormat).setValue(INI_BASE_SERIAL, m_index);
    }

    return res;
}

bool OrderEntryWork::insertXSFKFStable(OrderObject order,QString &error)
{
    QString XSDH = order.order_id;
    QString BM;
    QString NR;
    QString channel = order.channel;
    if(channel == "mt") {
        BM = "MTWMBDSR";
        NR = QString::fromLocal8Bit(XSFKFS_BM_MT) + QString("-") + QString(order.pay_type);
    } else if(channel == "elm") {
        BM = "ELMBDSR";
        NR = QString::fromLocal8Bit(XSFKFS_BM_ELM) + QString("-") + QString(order.pay_type);
    } else if(channel == "bd") {
        BM = "BDWMBDSR";
        NR = QString::fromLocal8Bit(XSFKFS_BM_BD) + QString("-") + QString(order.pay_type);
    } else if(channel == "jddj") {
        BM = "JDDJBDSR";
        NR = QString::fromLocal8Bit(XSFKFS_BM_JDDJ) + QString("-") + QString(order.pay_type);
    } else if(channel == "saas") {
        BM = "SAASBDSR";
        NR = QString::fromLocal8Bit(XSFKFS_BM_SAAS) + QString("-") + QString(order.pay_type);
    }

    double  FKJE = order.user_fee/100.00;
    int     DYQZS = 1;

    QSqlQuery query(m_db);
    QString str = QString("INSERT INTO [dbo].[XSFKFS] (XSDH,BM,NR,FKJE,DYQZS) VALUES ("
                          "'%1','%2','%3',%4,%5);")
            .arg(XSDH).arg(BM).arg(NR).arg(FKJE).arg(DYQZS);

    QLOG_DEBUG() << "insert XSFKFStable SQL str:" << str;

    bool res = query.exec(str);
    if(!res) {
        error = query.lastError().databaseText();
        QLOG_ERROR() << "insert XSFKFStable error:" << error;
    }


    return res;

}
