#include "networkcheckwork.h"
#include "base/Network/ping.h"
#include <QApplication>
#include <QSettings>
#include "preDefine.h"
#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"


NetworkCheckWork::NetworkCheckWork(WorkObject *parent) : WorkObject(parent)
{
    _status = true;
    _flag = true;
    QString filename = qApp->applicationDirPath() + "/" + CONFIG_NAME;
    _checkIP = QSettings(filename, QSettings::IniFormat).value(CONFIG_CHECKIP_IP).toString();
    _checkNum = QSettings(filename, QSettings::IniFormat).value(CONFIG_CHECKIP_INDEX).toInt();

    if(_checkIP.isEmpty())
        _checkIP= QString("114.114.114.114");

    if(_checkNum == 0)
        _checkNum = 2;

    index = 0;
}

NetworkCheckWork::~NetworkCheckWork()
{
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

void NetworkCheckWork::workstart()
{
    QLOG_INFO() << "NetworkCheckWork::workStart : " << QThread::currentThreadId();
    CPing netPing;
    bool flag = false;


    PingReply reply = { 0 };

    char ipbuf[MAX_PATH] = { 0 };

    strcpy(ipbuf, _checkIP.toUtf8().data());

    QLOG_DEBUG() << "NetworkCheckWork::workstart ipbuf:" << ipbuf;

    while(!_stopflag) {
        flag = netPing.Ping(ipbuf, &reply);

        if(flag) {
            index = 0;
        } else {
            index++;
        }

        bool status = index < _checkNum;

        //QLOG_DEBUG() << "status : "  << status;
        //QLOG_DEBUG() << "flag : "  << flag;
        //QLOG_DEBUG() << "index : "  << index;

        //如果当前状态不等于网络状态推送信息
        if(_status != status)
        {
            _status = status;
            QVariantMap map;
            map.insert(EVENT_KEY_NETWORKSTATUS, status);
            POSTEVENTTYPE(PosEvent::s_network_outtime,map,QVariantMap);
        }

        if(_stopflag) {
            break;
        }

        QTimer timer;
        QEventLoop loop;
        connect(this, &NetworkCheckWork::quit, &loop, &QEventLoop::quit);
        connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
        timer.start(DEFAULT_NETWORK_TIMEOUT);
        loop.exec();
    }
    QLOG_INFO() << "NetworkCheckWork::workstart quit";
    _stoped = true;
}
