#ifndef DRIVERINFOGETWORK_H
#define DRIVERINFOGETWORK_H

#include <QEvent>
#include <QString>
#include <QJsonObject>
#include <QTimer>
#include <QEventLoop>
#include "workobject.h"
#include "preDefine.h"
#include "model/posorderpool.h"
#include "base/Arithmetic/cretopt.h"

#define ADVANCEORDER 0

class DriverInfoGetWork : public WorkObject
{
    Q_OBJECT
public:
    explicit DriverInfoGetWork(WorkObject *parent = 0);

    ~DriverInfoGetWork();

    bool event(QEvent *e);

    void setUrl(const QString &url);

signals:
    void quitwork();

    void quitGetWork();

public slots:
    void workstart();

private:
    bool getDriverInfo();

    bool praseRecvJson(QJsonObject &json);

private:

    QVariantMap _storeinfo;

    QString _token;

    QString _url;

};

class GetDriverInfoDataProcess
{
public:
    friend class DriverInfoGetWork;
private:
    static bool getAction(int REQ, QString &action)
    {
#ifndef USE_QAACTION
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("saas.order.deliveryInfo");
                return true;
            default:
                return false;
        }
#else
        switch (REQ)
        {
            case ADVANCEORDER:
                action = QString("qasaas.order.deliveryInfo");
                return true;
            default:
                return false;
        }
#endif
    }

    static bool getAccess_Token(QString &access_toekn)
    {
        access_toekn = DEFAULT_ACCESS_TOKEN;
        return true;
    }

    static bool getVer(QString &ver)
    {
        ver = "1";
        return true;
    }

    static bool getRealUrl(int reqtype, const QJsonObject &json, const QString &url, QString &realurl)
    {

        QString action, access_token, ver, sign;

        if(!GetDriverInfoDataProcess::requestGetRSASign(reqtype, json, sign, action, access_token, ver))
            return false;

        QString tmpurl = url;

        realurl = tmpurl.arg(action, access_token, ver, sign);

        return true;
    }

    static bool requestGetRSASign(int reqtype, const QJsonObject &json, QString &sign, QString &action, QString &access_token, QString &ver)
    {
        QJsonObject tmpjson;

        if(!GetDriverInfoDataProcess::getAction(reqtype, action) ||
            !GetDriverInfoDataProcess::getAccess_Token(access_token) ||
                !GetDriverInfoDataProcess::getVer(ver))
            return false;

        GetDriverInfoDataProcess::getComplateJson(action, access_token, ver, json, tmpjson);
        return CretOperate::GetSign(tmpjson, sign);
    }

    static void getComplateJson(QString action, QString access_token, QString ver, const QJsonObject &json, QJsonObject &complatejson)
    {
        complatejson = json;

        complatejson.insert(JSON_KEY_ACTION, action);
        complatejson.insert(JSON_KEY_ACCESS_TOKEN, access_token);
        complatejson.insert(JSON_KEY_VER, ver);
    }

    static bool getDriverInfoRequest(QJsonObject &data, QVariantMap &map)
    {
        if(!map.contains(JSON_STOREID)) {
            return false;
        }
        data.insert(JSON_KEY_PARTNERID, map[JSON_KEY_PARTNERID].toString());
        data.insert(JSON_STOREID, map[JSON_STOREID].toString());
        return true;
    }

};

#endif // DRIVERINFOGETWORK_H
