#include "driverinfogetwork.h"

#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"
#include <QJsonArray>
#include "model/posorderpool.h"

DriverInfoGetWork::DriverInfoGetWork(WorkObject *parent) : WorkObject(parent)
{
    FMApplication::subscibeEvent(this, PosEvent::s_get_order_status);
    FMApplication::subscibeEvent(this, PosEvent::s_token_change);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
    FMApplication::subscibeEvent(this, PosEvent::s_need_get_driver_info);
}

DriverInfoGetWork::~DriverInfoGetWork()
{
    qDebug() << "";
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

bool DriverInfoGetWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_get_order_status)
    {
        bool isgetorder = false;

        GETEVENTINFO(isgetorder, e, bool);

        QLOG_DEBUG() << "DriverInfoGetWork::event::PosEvent::s_get_order_status:" << isgetorder;

        if(isgetorder)
        {
            emit quitGetWork();
        }

        return true;
    }

    if(e->type() == PosEvent::s_token_change)
    {
        QString token;

        GETEVENTINFO(token, e, QString);

        QLOG_DEBUG() << "DriverInfoGetWork::event::PosEvent::s_token_chang:" << token;

        _token = token;

        emit quit();

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap storeinfo;

        GETEVENTINFO(storeinfo,e,QVariantMap);

        QLOG_DEBUG() << "StallsGetWork::event::PosEvent::s_login_storeinfo:" << storeinfo;

        _storeinfo = storeinfo;

        return true;
    }

    if(e->type() == PosEvent::s_need_get_driver_info)
    {
        QLOG_INFO() << QThread::currentThreadId() << "OrderGetWork PosEvent::s_need_get_order";
        emit quitwork();
        return true;
    }

    return WorkObject::event(e);
}

void DriverInfoGetWork::setUrl(const QString &url)
{
    _url = url;
}

void DriverInfoGetWork::workstart()
{
    if(_token.isEmpty())
    {
        QEventLoop loop;
        connect(this, &DriverInfoGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }

    //加入登陆标志位，防止未登录线程启动后阻塞，导致未登录退出阻塞
//    if(_islogin)
//    {
//        QEventLoop loop;
//        connect(this, &DriverInfoGetWork::quitGetWork, &loop, &QEventLoop::quit);
//        connect(this, &DriverInfoGetWork::quit, &loop, &QEventLoop::quit);
//        loop.exec();
//    }


    QEventLoop loop;
    connect(this, &DriverInfoGetWork::quitGetWork, &loop, &QEventLoop::quit);
    connect(this, &DriverInfoGetWork::quit, &loop, &QEventLoop::quit);
    loop.exec();


    QLOG_DEBUG() << "DriverInfoGetWork::workstart loop start";

    while(!_stopflag)
    {

        if(!getDriverInfo())
        {
            QLOG_WARN() << "DriverInfoGetWork::getDriverInfo failed wait " << DEFAULT_STALLS_TIMEOUT;
            QTimer timer;
            QEventLoop loop;
            connect(this, &DriverInfoGetWork::quit, &loop, &QEventLoop::quit);
            connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
            timer.start(DEFAULT_STALLS_TIMEOUT);
            loop.exec();
            continue;
        }

        //获取档口信息完成后检擦是否退出表示
        if(_stopflag)
            break;

        QEventLoop loop;
        connect(this, &DriverInfoGetWork::quit, &loop, &QEventLoop::quit);
        connect(this, &DriverInfoGetWork::quitwork, &loop, &QEventLoop::quit);
        loop.exec();
    }
    _stoped = true;
}

bool DriverInfoGetWork::getDriverInfo()
{
    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!GetDriverInfoDataProcess::getDriverInfoRequest(json, _storeinfo))
    {
        QLOG_ERROR() << "getDriverInfoRequest failed";
        return false;
    }

    QLOG_INFO() << "getDriverInfoRequest request json : " << json;

    if(!GetDriverInfoDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "GetDriverInfoDataProcess getRealUrl failed";
        return false;
    }

    QLOG_INFO() << "GetDriverInfoDataProcess request url :" << realurl;

    if(!this->S_Request(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "getDriverInfo failed : " << error;
        return false;
    }

    QLOG_INFO() << "getDriverInfo return json : " << recvjson;

    return praseRecvJson(recvjson);
}

bool DriverInfoGetWork::praseRecvJson(QJsonObject &json)
{
    if(!json.contains(JSON_KEY_CODE) || QString("ok").compare(json[JSON_KEY_CODE].toString(), Qt::CaseInsensitive) != 0)
    {
        QLOG_ERROR() << "DriverInfoGetWork::praseRecvJson failed";
        return false;
    }

    if(!json.contains(JSON_KEY_RESULT))
    {
        QLOG_ERROR() << "DriverInfoGetWork::praseRecvJson failed";
        return false;
    }

    QJsonArray result = json[JSON_KEY_RESULT].toArray();
    QLOG_DEBUG() << "QJsonArray result:" << result.size();
    for(int i = 0;i < result.size(); i++)
    {
        QJsonObject driverInfo = result.at(i).toObject();
        QLOG_DEBUG() << "driverinfo input:" << driverInfo;
        QVariantMap map;
        map.insert(JSON_ORDERID, driverInfo["order_id"].toString());
        map.insert("rider_name", driverInfo["rider_name"].toString());
        map.insert("rider_phone", driverInfo["rider_phone"].toString());

        POSTEVENTTYPE(PosEvent::s_get_driver_info,map,QVariantMap);


    }
    return true;
}
