#include "drivercancelordergetwork.h"

#include "event/fmapplication.h"
#include "event/posevent.h"
#include "QsLog.h"
#include <QJsonArray>
#include "model/posorderpool.h"

DriverCancelOrderGetWork::DriverCancelOrderGetWork(WorkObject *parent) : WorkObject(parent)
{
    FMApplication::subscibeEvent(this, PosEvent::s_token_change);
    FMApplication::subscibeEvent(this, PosEvent::s_login_storeinfo);
    FMApplication::subscibeEvent(this, PosEvent::s_driver_cancel_order);
}

DriverCancelOrderGetWork::~DriverCancelOrderGetWork()
{
    qDebug() << "";
    while(!_stoped)
    {
        _stopflag = true;
        emit quit();
        EVENTWAIT(10);
    }
}

bool DriverCancelOrderGetWork::event(QEvent *e)
{
    if(e->type() == PosEvent::s_token_change)
    {
        QString token;

        GETEVENTINFO(token, e, QString);

        QLOG_DEBUG() << "DriverCancelOrderGetWork::event::PosEvent::s_token_chang:" << token;

        _token = token;

        emit quit();

        return true;
    }

    if(e->type() == PosEvent::s_login_storeinfo)
    {
        QVariantMap storeinfo;

        GETEVENTINFO(storeinfo,e,QVariantMap);

        QLOG_DEBUG() << "DriverCancelOrderGetWork::event::PosEvent::s_login_storeinfo:" << storeinfo;

        _storeinfo = storeinfo;

        return true;
    }

    if(e->type() == PosEvent::s_driver_cancel_order)
    {
        QLOG_INFO() << QThread::currentThreadId() << "DriverCancelOrderGetWork PosEvent::s_need_get_order";
        QVariantMap map;
        GETEVENTINFO(map,e,QVariantMap);
        _orderid = map["order_id"].toString();
        emit quitwork();
        return true;
    }

    return WorkObject::event(e);
}

void DriverCancelOrderGetWork::setUrl(const QString &url)
{
    _url = url;
}

void DriverCancelOrderGetWork::workstart()
{
    if(_token.isEmpty())
    {
        QEventLoop loop;
        connect(this, &DriverCancelOrderGetWork::quit, &loop, &QEventLoop::quit);
        loop.exec();
    }

    QEventLoop loop;
    connect(this, &DriverCancelOrderGetWork::quitwork, &loop, &QEventLoop::quit);
    connect(this, &DriverCancelOrderGetWork::quit, &loop, &QEventLoop::quit);
    loop.exec();

    while(!_stopflag)
    {
        if(!getDriverCancelOrder())
        {
            QLOG_WARN() << "DriverCancelOrderGetWork::getDriverCancelOrder failed wait " << DEFAULT_STALLS_TIMEOUT;
            QTimer timer;
            QEventLoop loop;
            connect(this, &DriverCancelOrderGetWork::quit, &loop, &QEventLoop::quit);
            connect(&timer, &QTimer::timeout, &loop, &QEventLoop::quit);
            timer.start(DEFAULT_STALLS_TIMEOUT);
            loop.exec();
            continue;
        }

        //获取档口信息完成后检擦是否退出表示
        if(_stopflag)
            break;

        QEventLoop loop;
        connect(this, &DriverCancelOrderGetWork::quit, &loop, &QEventLoop::quit);
        connect(this, &DriverCancelOrderGetWork::quitwork, &loop, &QEventLoop::quit);
        loop.exec();
    }
    _stoped = true;
}

bool DriverCancelOrderGetWork::getDriverCancelOrder()
{
    QJsonObject json, recvjson;
    QString realurl;
    QString error;

    if(!GetDriverCancelOrderDataProcess::getDriverInfoRequest(json, _storeinfo, _orderid))
    {
        QLOG_ERROR() << "getDriverInfoRequest failed";
        return false;
    }

    QLOG_INFO() << "getDriverInfoRequest request json : " << json;

    if(!GetDriverCancelOrderDataProcess::getRealUrl(ADVANCEORDER, json, _url, realurl))
    {
        QLOG_ERROR() << "GetDriverInfoDataProcess getRealUrl failed";
        return false;
    }

    QLOG_INFO() << "GetDriverInfoDataProcess request url :" << realurl;

    if(!this->S_Request(json, recvjson, realurl, error))
    {
        QLOG_ERROR() << "getDriverInfo failed : " << error;
        return false;
    }

    QLOG_INFO() << "getDriverInfo return json : " << recvjson;

    return praseRecvJson(recvjson);
}

bool DriverCancelOrderGetWork::praseRecvJson(QJsonObject &json)
{
    if(!json.contains(JSON_KEY_CODE) || QString("ok").compare(json[JSON_KEY_CODE].toString(), Qt::CaseInsensitive) != 0)
    {
        QLOG_ERROR() << "DriverCancelOrderGetWork::praseRecvJson failed";
        return false;
    }

    if(!json.contains(JSON_KEY_RESULT))
    {
        QLOG_ERROR() << "DriverCancelOrderGetWork::praseRecvJson failed";
        return false;
    }

    QJsonObject result = json[JSON_KEY_RESULT].toObject();
    if(result.contains("delivery_status") && result["delivery_status"].toInt() == 7 && result.contains("delivery_desc"))
    {
        QVariantMap map;
        map.insert("order_id", result["order_id"].toString());
        map.insert("delivery_desc", result["delivery_desc"].toString());
        map.insert("rider_name", result["courier_name"].toString());
        map.insert("rider_phone", result["courier_phone"].toString());
        POSTEVENTTYPE(PosEvent::s_driver_cancel_reason, map, QVariantMap);
    }else {
        return false;
    }

    return true;


}


