#ifndef DOWNLOADER_H
#define DOWNLOADER_H


#include <QFile>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QObject>
#include <QUrl>

class Downloader : public QObject {
    Q_OBJECT


public:
    explicit Downloader(QObject *parent = 0) : QObject(parent),m_manager(nullptr)
    {
        m_isReady = true;
        m_manager = new QNetworkAccessManager(this);
       bool value = connect(m_manager, &QNetworkAccessManager::finished, this, &Downloader::onDownloadFileComplete);
       qDebug()<<"-------------------------------"<<m_manager<<"     "<<value;
       m_manager->setNetworkAccessible(QNetworkAccessManager::Accessible);
    }
    virtual ~Downloader() {}

    void downloadFileFromURL(const QString &url, const QString &filePath);

private slots:
    void onDownloadFileComplete(QNetworkReply *reply);
private:
    QNetworkAccessManager *m_manager;
    QFile *m_file;
    bool m_isReady;
};



#endif // DOWNLOADER_H
