﻿#include "downloader.h"
#include <QDebug>
#include <QEventLoop>

void Downloader::downloadFileFromURL(const QString &url, const QString &filePath)
{
    if (!m_isReady)
        return;
    m_isReady = false;

    const QString fileName = filePath + url.right(url.size() - url.lastIndexOf("/"));
    qDebug() << fileName;
    m_file = new QFile();
    m_file->setFileName(fileName);
    m_file->open(QIODevice::WriteOnly);
    if (!m_file->isOpen()) {
        m_isReady = true;
        return;
    }

    QNetworkRequest request;
    request.setUrl(QUrl(url));
    qDebug() << "--------------60601------------";

    m_manager->get(request);
}

void Downloader::onDownloadFileComplete(QNetworkReply *reply)
{
    qDebug() << "--------------60602------------";
    if (!m_file->isWritable()) {
        m_isReady = true;
        return;
    }
    qDebug() << "-------------7070------------";
    m_file->write(reply->readAll());
    m_file->close();
    m_isReady = true;
}


//Downloader::Downloader(QObject *parent)
//    :QObject(parent),m_reply(0)
//{
//    m_network = new QNetworkAccessManager(this);
//}

//Downloader::~Downloader()
//{
//    if(m_reply) {
//        m_reply->deleteLater();
//        m_reply = 0;
//    }
//}

//void Downloader::download(const QString &url)
//{
//    qDebug() << "--------------6060------------";
//    QUrl qurl(url);
//    QNetworkRequest request(qurl);//构造一个请求
//    if(m_reply)
//    {
//        m_reply->disconnect(this);
//        m_reply->deleteLater();
//        m_reply = 0;
//    }
//    m_reply = m_network->get(request);//获得请求
//    connect(m_reply,SIGNAL(readyRead()),this,SLOT(onReadyRead()));//连接信号和槽
//    connect(m_reply,SIGNAL(error(QNetworkReply::NetworkError)),
//            this,SLOT(onError(QNetworkReply::NetworkError)));
//    connect(m_reply,SIGNAL(finished()),this,SLOT(onFinished()));
//    connect(m_reply,SIGNAL(sslErrors(QList<QSslError>)),
//            this,SLOT(onSslError(QList<QSslError>)));
//}


//void Downloader::onReadyRead()
//{
//    qDebug() << "--------------6060------------";
//    data.append( m_reply->readAll());//图片过大是每次读一点，一定要记得拼接
//    qDebug()<<"readyread"<<data.length()<<"byte data"<<endl;
//}

//void Downloader::onError(QNetworkReply::NetworkError error)
//{

//    m_reply->disconnect(this);
//    m_reply->deleteLater();
//    m_reply = 0;
//    qDebug()<<"http_error"<<error<<endl;
//}

//void Downloader::onFinished()
//{
//    //data转MD5
//    qDebug() << "-------------6060--------------";
//    QString md5;
//    QByteArray bb;
//    bb = QCryptographicHash::hash ( data, QCryptographicHash::Md5 );
//    md5.append(bb.toHex());

//    QFile file(QApplication::applicationDirPath() + "/prtinfo/1.png");
//    file.open(QIODevice::ReadWrite);
//    QByteArray t = file.readAll();
//    QString md5New;
//    QByteArray tmp;
//    tmp = QCryptographicHash::hash ( t, QCryptographicHash::Md5 );
//    md5New.append(tmp.toHex());

//    if(md5 != md5New) {
//        file.write(data);
//    }

//    file.close();

//    m_reply->disconnect(this);
//    m_reply->deleteLater();
//    m_reply = 0;
//    qDebug()<<"download finished"<<endl;
//}

//void Downloader::onSslError(QList<QSslError>)
//{
//    qDebug()<<"sslerror"<<endl;
//}



