#include <Windows.h>
#include <Winspool.h>
#include <QString>
#include <QStringList>
#include <QPrinterInfo>

class GetPrinters {
public:
    static bool GetPrintersName(QStringList &printerlist)
    {
        QList<QPrinterInfo> list = QPrinterInfo::availablePrinters();

        foreach (auto var, list) {
            printerlist.append(var.printerName());
        }

        if(printerlist.isEmpty())
            return false;
        return true;
    }

    static BOOL HasPrintersName(QStringList &printerlist)
	{
		DWORD Flags = PRINTER_ENUM_FAVORITE | PRINTER_ENUM_LOCAL; //local   printers
		DWORD cbBuf;
		DWORD pcReturned;

		DWORD Level = 2;
		TCHAR Name[500]   ;
		LPPRINTER_INFO_2 pPrinterEnum = NULL;

		memset(Name,0,sizeof(TCHAR)*500);
		::EnumPrinters(Flags, Name, Level, NULL, 0, &cbBuf, &pcReturned);
		pPrinterEnum = (LPPRINTER_INFO_2)LocalAlloc(LPTR, cbBuf+4);

		if (NULL == pPrinterEnum)
		{
			return   FALSE;
		}

		if (!EnumPrinters(
			Flags,    //   DWORD   Flags,   printer   object   types  
			Name,    //   LPTSTR   Name,   name   of   printer   object  
			Level,    //   DWORD   Level,   information   level  
			(LPBYTE)pPrinterEnum,    //   LPBYTE   pPrinterEnum,   printer   information   buffer  
			cbBuf,    //   DWORD   cbBuf,   size   of   printer   information   buffer
			&cbBuf, //   LPDWORD   pcbNeeded,   bytes   received   or   required  
			&pcReturned)    //   LPDWORD   pcReturned   number   of   printers   enumerated  
			)
		{
			return FALSE;
		}

		LPPRINTER_INFO_2 p = pPrinterEnum;
		for (int i=0; i<pcReturned;i++)
		{		
			//wprintf( L"PrinterName: %s\n ", p->pPrinterName);
            printerlist.append(QString::fromWCharArray(p->pPrinterName));
			p++;
		}


		if (pcReturned > 0)
		{
			return TRUE;
		}
		else 
		{
			return FALSE;
		}  
	}
};

