﻿#ifndef PRINTLIB_H
#define PRINTLIB_H
#include <QLibrary>

#include "Model/productObject.h"
#include "Model/orderObject.h"
#include <QString>
#include "Calculator.h"
#include "printdocument.h"



class PrintLib
{

public:
    PrintLib();

public:
    static PrintLib& GetInstance();

    bool DoPrint(const QByteArray &content, OrderObject *orderObject, QString &error, bool other_prt = false);
    bool DoPrint(const QString &content, OrderObject *orderObject, QString &error, bool other_prt = false);

    void _PrintLab( OrderObject* order);
    //bool OpenPrinter();
    //void ClosePrinter();
//    bool PrintQRCode(char data[], int type,  int leftMargin,int width);
//    bool PrintBarCode(char data[],int type, int leftMargin,int fontType,int width,int height,int position);
//    bool PrintText(char data[], int fontType,int fontStyle ,int width,int height);
//    bool FreeLine();

    bool DoTestLabelPrint(QByteArray iniData, OrderObject *orderObject);
    bool DoTestPrint(QByteArray iniData, const QString &content, OrderObject *orderObject, QString &error);
    void _PrintLabTest();
    QString _OnlyGetPrintIni(bool other_prt = false);
    bool OnlyDoPrint(const QString &content, OrderObject *orderObject, QString &error, bool other_prt = false);
private:

    typedef bool ( *OpenPrinter)( void);
    typedef void ( *InitPrinter)( char str[]);
    typedef void ( *PrintText)( char str[]);
    typedef void ( *ClosePrinter)(void);
    typedef bool ( *LoadAddress)(void);
    typedef int  (*Total)(int);

    typedef int (*TSCInit)();
    typedef int (*TSCWinPrintln)(int x, int y, int font_size, int rotate, int font_type, int high_len, int line, char *font_name, char *data, double font_ratio);
    typedef int (*TSCWinPrintPage)(char *page, char *num);

    //打印行
    typedef bool (*PrintLine)(char data[], int ,int  ,int ,int );
    //打印条码
    typedef bool (*PrintBarCode)(char data[],int , int ,int ,int ,int ,int );
    //打印二维码
    typedef bool (*PrintQRCode)(char data[], int ,  int ,int );
    //空行
    typedef bool (*FreeLine)();



    int total;
    QLibrary m_print_lib;
    bool m_b_load_sucfl;
    OpenPrinter f_OpenPrinter;
    InitPrinter f_InitPrinter;
    PrintText f_PrintText;
    ClosePrinter f_ClosePrinter;
    LoadAddress f_LaodAddress;
    FreeLine f_FreeLine;
    Total f_total;
    PrintLine f_PrintLine;
    PrintBarCode f_PrintBarCode;
    PrintQRCode f_PrintQRCode;
    QStringList _list;

    TSCInit f_TSCInit;
    TSCWinPrintln f_TSCWinPrintln;
    TSCWinPrintPage f_TSCWinPrintPage;

    OrderObject *_order;
    QString _GetPrintIni(bool other_prt = false);
    void _PrintLine(const LineNode& line,  ProductObject* dish=0);
    void _PrintProcudt(const QList<LineNode *> &list, const QList<int> &protlist);
    bool _PrintLineNode(const PrintDocument &doc, OrderObject *orderObject);
    void _FreeLine();



};

#endif // PRINTLIB_H
