#ifndef NEWPRINTLIB_H
#define NEWPRINTLIB_H

#include "Model/productObject.h"
#include "Model/orderObject.h"
#include "printdocument.h"

typedef void (*Unloaddll)();

typedef bool (*LoadAddress)();

typedef int (*LabPrtOpen)(char data[]);

typedef int (*LabPrtLine)(int x, int y, int line, const char *data);

typedef int (*LabPrtLineWithSizeAndRatio)(int x, int y, int size, double ratio, int line, const char *data);

typedef int (*LabPrtLineWithSizeAndStyle)(int x, int y, int size, int style, int line, const char *data);

typedef int (*LabPrtClose)();

typedef int (*PrtOpen)(char data[]);

typedef int (*PrtClose)();

typedef void (*FreeLine)();

typedef bool (*PrintDataLine)(char data[], int fontType, int fontStyle, int width, int height);

typedef bool (*PrintBarCode)(char data[], int type, int leftMargin, int fontType, int width, int height, int position);

typedef bool (*PrintQRCode)(char data[], int type,  int leftMargin, int width);

typedef void (*DoPrintWithXml)(char *prtstr, char *orderStr, char*xmlStr, char* error);

typedef void (*DoLabPrintWithXml)(char *prtstr, char *orderStr, char*xmlStr, char* error);

class NewPrintLib
{
public:
    NewPrintLib();

    ~NewPrintLib();

    static NewPrintLib& GetInstance();

    /*!
     * \brief DoPrint   小票打印
     * \param connect   打印模板上下文
     * \param config    打印配置
     * \param order     订单对象
     * \return          true:成功 false:失败
     */
    bool DoPrint(const QString &config, const QString &context, OrderObject *order, int page);
    /*!
     * \brief DoBackPrint   后厨打印
     * \param page_depart   每种商品打印一页
     * \param connect       后厨打印模板上下文
     * \param prod_depart   每个商品打印一行
     * \param config        后厨打印机配置
     * \param stallsprods   档口对应商品编号列表
     * \param prod          商品列表
     * \return              true:成功 false:失败
     */
    bool DoBackPrint(int page_depart, int prod_depart, int page_num,
                     const QStringList &stallsprods, const QString &config,
                     const QString &context, OrderObject *order, int page);

    /*!
     * \brief DoLabelPrint  杯贴机打印
     * \param config        杯贴打印机配置
     * \param prod          商品
     * \return              true:成功 false:失败
     */
    bool DoLabelPrint(const QString &config, OrderObject *order);

    /*!
     * \brief DoLabelModelPrint   杯贴打印
     * \param connect             打印模板上下文
     * \param config              打印配置
     * \param order               订单对象
     * \return                    true:成功 false:失败
     */
    bool DoLabelModelPrint(const QString &config, const QString &context, OrderObject *order);

private:
    bool LoadFunction();

    bool PrintLineNode(const PrintDocument &doc, OrderObject *_order);

    void PrintLine(const LineNode &line, ProductObject *dish, OrderObject *_order);

    void PrintProcudt(const QList<LineNode *> &list, const QList<int> &protlist, OrderObject *_order);

    void AddProdJson(OrderObject &des_order, ProductObject* prod);

    bool GetObjList(int page_depart, int prod_depart, QStringList prodlist, QList<OrderObject> &orderlist, OrderObject *order);

    bool GetProdObject(int prod_depart, QList<OrderObject> &orderlist, OrderObject *order);

    bool GetProdList(const QStringList &stallsprods, OrderObject *order, QStringList &prodlist);

    bool PrintLabel(const QString &config, OrderObject *order);
private:
    Unloaddll f_unloaddll;

    LoadAddress f_loadaddress;

    LabPrtOpen f_labprtiopen;

    LabPrtLine f_labprtline;

    LabPrtLineWithSizeAndRatio f_labprtlinewithsizeandratio;

    LabPrtLineWithSizeAndStyle f_labprtlinewithsizeandstyle;

    LabPrtClose f_labprtclose;

    PrtOpen f_prtopen;

    PrtClose f_prtclose;

    FreeLine f_freeline;

    PrintDataLine f_printdataline;

    PrintBarCode f_printBarcode;

    PrintQRCode f_printqrcode;

    DoPrintWithXml f_DoPrintWithXml;

    DoLabPrintWithXml f_DoLabPrintWithXml;

    bool _load_flag;
};

#endif // NEWPRINTLIB_H
