#include "newprintlib.h"

#include <Windows.h>

#include <QLibrary>

#include <QApplication>
#include <QDateTime>

#include "QsLog.h"

#include "preDefine.h"
#include "calculator.h"
#include "model/posorderpool.h"
#include <QJsonDocument>
#include <QJsonArray>
#include <QSettings>

NewPrintLib::NewPrintLib()
{
    _load_flag = false;
    LoadFunction();
}

NewPrintLib::~NewPrintLib()
{
    if(f_unloaddll)
        f_unloaddll();
}

NewPrintLib &NewPrintLib::GetInstance()
{
    static NewPrintLib fp;
    return fp;
}

#define CONSTCHARTOCHAR(src, des) do {      \
    des = new char[src.size() + 1];         \
    memcpy(des, src.data(), src.size());    \
    des[src.size()]  = 0;                   \
}while(0);

bool NewPrintLib::PrintLineNode(const PrintDocument &doc, OrderObject *_order)
{
    QList<int> productNodeList = doc.GetProductNodeIndex();
    QList<LineNode*> list = doc.GetNodeList();
    bool first=true;
    for(int i=0;i<list.size();i++)
    {
        if(productNodeList.contains(i))
        {
            if(first){
                first = false;
                PrintProcudt(list, productNodeList, _order);
            }

        }
        else
        {
            PrintLine(*list.at(i), NULL, _order);
        }
    }
    return first;
}

void NewPrintLib::PrintLine(const LineNode &line, ProductObject *dish, OrderObject *_order)
{
    QString text = line.text;
    QString content = line.content;
    int time = line.time;
    int printType = line.printType;
    int fontType = line.fontType;
    int fontStyle = line.fontStyle;
    int width = line.width;
    int height = line.height;
    int codeType = line.codeType;
    int position = line.position;
    int leftMargin = line.leftMargin;
    QStringList contentList;
    content.simplified();
    contentList = content.split('|');
    int i=1;
    foreach(QString value,contentList)
    {
        QStringList list;
        bool isMath = false;
        QString format;
        Calculator::SplitMath(value,list,format ,isMath );
        QString index= QString("%%1").arg(i++);
        if(!isMath){
            QVariant v;
            if(dish==0){
                 v = _order->property(value.toUtf8());
            }
            else{
                 v = dish->property(value.toUtf8());
            }
            if(time)
            {
                int delivertime = v.toInt();
                if(delivertime == 0)
                {
                    text.replace(index,QDateTime::currentDateTime().toString("yyyy-MM-dd hh:mm"));
                }else{
                    text.replace(index,QDateTime::fromTime_t(v.toInt()).toString("yyyy-MM-dd hh:mm"));
                }
            }else
            {
                text.replace(index,v.toString());
            }
        }
        else{
            int j=1;
            foreach(QString value,list)
            {
                QString index= QString("%%1").arg(QString::number(j++));
                bool ok;
                value.toInt(&ok,10);
                if(ok)
                {
                    format.replace(index,value);
                    continue;
                }
                QVariant v;
                if(dish==0){
                     v = _order->property(value.toUtf8());
                }
                else{
                     v = dish->property(value.toUtf8());
                }
                if(time)
                {
                    format.replace(index,QDateTime::fromTime_t(v.toInt()).toString("yyyy-MM-dd hh:mm"));
                }else
                {
                    format.replace(index,v.toString());
                }
            }
            format.insert(0,'(');
            format.append(')');
            float result=Calculator::parenth_final(string((const char *)format.toUtf8()));
            text.replace(index,QString::number(result));
        }
    }
    char temchar[2048]={0x0};
    strcpy(temchar,text.toLocal8Bit().data());
    if(printType==1)
    {
        f_printdataline(temchar,fontType,fontStyle,width,height) ;
    }
    if(printType==2)
    {
        f_printqrcode(temchar,codeType,leftMargin,width);
    }
    if(printType==3)
    {
        f_printBarcode(temchar,codeType,leftMargin,fontType,width,height,position);
    }
    memset(temchar,0x0,sizeof(temchar));
}

void NewPrintLib::PrintProcudt(const QList<LineNode*> &list,const QList<int>& protlist, OrderObject *_order)
{
    QList<int> productNodeList = protlist;
    int firstIndex = productNodeList.first();
    int lastIndex = productNodeList.last();
    foreach (ProductObject* value, _order->proList) {
        for(int index = firstIndex;index<=lastIndex;index++) {
              PrintLine(*list.at(index),value, _order);
        }
    }
}

#define ORDERINFOCOPY(src, des) do {            \
    des.create_time = src->create_time;         \
    des.order_index = src->order_index;         \
    des.order_id = src->order_id;               \
    des.store_name = src->store_name;           \
    des._orderObject = src->_orderObject;       \
    des._orderObject["products"] = QJsonArray();\
}while(0);

void NewPrintLib::AddProdJson(OrderObject &des_order, ProductObject* prod)
{
    QJsonArray array = des_order._orderObject["products"].toArray();
    QJsonObject object;
    object["pid"] = prod->pid;
    object["price"] = prod->price;
    object["name"] = prod->name;
    object["product_amount"] = prod->product_amount;

    //加入属性字段
    object["property_tags"] = prod->property_tags;
    array.append(object);
    des_order._orderObject["products"] = array;

}

bool NewPrintLib::GetObjList(int page_depart, int prod_depart, QStringList prodlist, QList<OrderObject> &orderlist, OrderObject *order)
{
    OrderObject allorder;
    ORDERINFOCOPY(order, allorder);

    foreach (auto v, order->proList) {
        if(prodlist.contains(v->pid))
        {
            if(page_depart == 1)
            {
                if(prod_depart == 0)
                {
                    OrderObject tmporder;
                    ORDERINFOCOPY(order, tmporder);
                    ProductObject *tmpod = new ProductObject(&tmporder);
                    *tmpod = *v;
                    tmporder.proList.append(tmpod);
                    AddProdJson(tmporder, tmpod);
                    QLOG_DEBUG() << "debug2" << tmporder._orderObject;
                    orderlist.append(tmporder);
                }
                else
                {
                   OrderObject tmporder;
                   ORDERINFOCOPY(order, tmporder);
                   QLOG_DEBUG() << "222222" << tmporder._orderObject;
                   for(int i = 0; i < v->product_amount; ++i)
                   {

                       ProductObject *tmpod = new ProductObject(&tmporder);
                       *tmpod = *v;
                       tmpod->product_amount = 1;
                       tmporder.proList.append(tmpod);
                       AddProdJson(tmporder, tmpod);
                       QLOG_DEBUG() << "debug3" << tmporder._orderObject;
                   }
                   orderlist.append(tmporder);
                }
            }
            else
            {
                if(prod_depart == 0)
                {
                    ProductObject *tmpod = new ProductObject(&allorder);
                    *tmpod = *v;
                    allorder.proList.append(tmpod);
                    AddProdJson(allorder, tmpod);
                    QLOG_DEBUG() << "debug4" << allorder._orderObject;
                }
                else
                {
                   for(int i = 0; i < v->product_amount; ++i)
                   {

                       ProductObject *tmpod = new ProductObject(&allorder);
                       *tmpod = *v;
                       tmpod->product_amount = 1;
                       allorder.proList.append(tmpod);
                       AddProdJson(allorder, tmpod);
                        QLOG_DEBUG() << "debug5" << allorder._orderObject;
                   }
                }
            }
        }
    }
    if(page_depart == 0 && !allorder.proList.isEmpty())
        orderlist.append(allorder);

    return (!orderlist.isEmpty());
}

bool NewPrintLib::DoPrint(const QString &config, const QString &context, OrderObject *order, int page)
{
    OrderObject tmporder = *order;

    QLOG_DEBUG() << "input1:" <<  tmporder._orderObject;

    if(!_load_flag && !LoadFunction())
    {
        QLOG_ERROR() << "NewPrintLib::DoPrint failed";
        return false;
    }

//    OrderObject tmporder = *order;

//    QLOG_DEBUG() << tmporder._orderObject;

    char *prtconfig = NULL;
    QByteArray prtconfigdata = config.toLocal8Bit();

    CONSTCHARTOCHAR(prtconfigdata, prtconfig);



    char *xml = NULL;
//    QByteArray xmldata = context.toUtf8();
    QByteArray xmldata = context.toLocal8Bit();

    CONSTCHARTOCHAR(xmldata, xml);



    char *orderinfo = NULL;
//    QByteArray orderdata = QString(QJsonDocument(tmporder._orderObject).toJson()).toUtf8();

    //根据订单号填写打印模板的表头
    QJsonObject orderObj = tmporder._orderObject;
    int type = -100;
    if(orderObj.contains("order_type")) {
        type = orderObj["order_type"].toInt();
    }

    QLOG_DEBUG() << "NewPrintLib::type:" << type;

    //桌号设置
    if(orderObj.contains("table_number") && orderObj["table_number"].toString() != "")
    {
        QLOG_DEBUG() << "NewPrintLib::table_number:" << orderObj["table_number"].toString();
        tmporder._orderObject["table_number"] = QString(orderObj["table_number"].toString() + QString::fromLocal8Bit(TABLE_NUMBER));
        QLOG_DEBUG() << "NewPrintLib::new_table_number:" << tmporder._orderObject["table_number"].toString();
    }
    //表头设置
    QString channel = orderObj["channel"].toString();

     QLOG_DEBUG() << "NewPrintLib::channel:" << channel;

     QString tableheadname = QApplication::applicationDirPath() + QString("/prtinfo/tablehead.ini");
     QSettings m_setting(tableheadname,QSettings::IniFormat);
     m_setting.setIniCodec("UTF-8");

     if(QString("saas").compare(channel, Qt::CaseInsensitive) == 0)
     {
         switch(type) {
         case TimelyTakeout:
             if(page == 56) {
                 if(m_setting.value("1").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("1").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYTAKEOUT));
                 }
             } else {
                 if(m_setting.value("5").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("5").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYTAKEOUT));
                 }
             }
             break;
         case AppointmentTakeout:
             if(page == 56) {
                 if(m_setting.value("7").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("7").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTTAKEOUT));
                 }
             } else {
                 if(m_setting.value("10").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("10").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTTAKEOUT));
                 }
             }

             break;
         case TimelyDining:
             if(page == 56) {
                 if(m_setting.value("2").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("2").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                 }
             } else {
                 if(m_setting.value("6").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("6").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                 }
             }

             break;
         case AppointmentDining:
             if(page == 56) {
                 if(m_setting.value("8").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("8").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                 }
             } else {
                 if(m_setting.value("11").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("11").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                 }
             }

             break;
         case TimelyInvite:
             if(page == 56) {
                 if(m_setting.value("2").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("2").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                 }
             } else {
                 if(m_setting.value("6").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("6").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                 }
             }
             break;
         case AppointmentInvite:
             if(page == 56) {
                 if(m_setting.value("8").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("8").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                 }
             } else {
                 if(m_setting.value("11").toString() != "") {
                     tmporder._orderObject.insert("source_order_type" , m_setting.value("11").toString());
                 } else {
                     tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                 }
             }
             break;
         default:
             break;
         }
     } else {
         switch(type) {
         case TimelyTakeout:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT));
             break;
         case AppointmentTakeout:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTTAKEOUT));
             break;
         case TimelyDining:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
             break;
         case AppointmentDining:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
             break;
         case TimelyInvite:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
             break;
         case AppointmentInvite:
             tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
             break;
         default:
             break;
         }
     }



    //将订单的预约时间拿过来转换成订单需要的QString类型
    int delivery_time = orderObj["delivery_time"].toInt();
    QLOG_DEBUG() << "prt_type" << type;
    QString prt_delivery_time;
    if(type == 1)
    {
        prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_TAKEOUT);
    }
    else if(type == 3 || type == 5)
    {
        prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_INVITE);
    }
    else
    {
        prt_delivery_time = QDateTime::fromTime_t(delivery_time).toString("yyyy/MM/dd hh:mm:ss");
    }

    tmporder._orderObject.insert("prt_delivery_time", prt_delivery_time);


    QLOG_DEBUG() << "NewNew tmporder._orderObject :" << tmporder._orderObject;
    QByteArray orderdata = QString(QJsonDocument(tmporder._orderObject).toJson()).toLocal8Bit();
    CONSTCHARTOCHAR(orderdata, orderinfo);


    char err[1024] = {0};

    f_DoPrintWithXml(prtconfig, orderinfo, xml,  err);

    if(strlen(err) > 0)
    {
        QLOG_ERROR() << "f_DoPrintWithXml failed error : " << err;
    }

    delete [] prtconfig;
    delete [] xml;
    delete [] orderinfo;

    QLOG_DEBUG() << "f_DoPrintWithXml success";

//    char* configStr;
//    char* contextStr;
//    QByteArray ba = config.toLatin1(); // must
//    configStr = ba.data();

//    QByteArray tmp = context.toLatin1();
//    contextStr = tmp.data();





//    if(!_load_flag && !LoadFunction())
//    {
//        QLOG_ERROR() << "NewPrintLib::DoPrint failed";
//        return false;
//    }

//    QByteArray data = config.toUtf8();

//    char *tmpconfig = NULL;

//    CONSTCHARTOCHAR(data, tmpconfig);

//    QLOG_DEBUG() << "tmpconfig:" << tmpconfig;

//    if(f_prtopen(tmpconfig) != 1)
//    {
//        QLOG_ERROR() << "NewPrintLib::DoPrint::f_prtopen failed";
//        delete [] tmpconfig;
//        f_prtclose();
//        return false;
//    }
//    delete [] tmpconfig;

//    bool result;
//    QString error;
//    PrintDocument doc = PrintDocument::ParseToDocument(context, result,error);
//    if(!result)
//    {
//        f_prtclose();
//        QLOG_ERROR() << "NewPrintLib::DoPrint::PrintDocument::ParseToDocument failed";
//        return false;
//    }

//    PrintLineNode(doc,order);

//    f_prtclose();
    return true;
}

bool NewPrintLib::GetProdList(const QStringList &stallsprods, OrderObject *order, QStringList &prodlist)
{
    QList<ProductObject *> list = order->proList;

    foreach (auto v, list) {
        if(stallsprods.contains(v->pid) || (stallsprods.size() == 1 && QString("DEFAULT").compare(stallsprods[0]) == 0))
            prodlist.append(v->pid);
    }
    return (!prodlist.isEmpty());
}

bool NewPrintLib::PrintLabel(const QString &config, OrderObject *order)
{
    QString deliveryTime;
    QString datetime;

    int tmpdelitime = order->srcdlv_time;

    if(order->delivery_time==0)
    {
        deliveryTime = QDateTime::currentDateTime().toString("hh:mm");
        datetime = QDateTime::currentDateTime().toString("MM/dd");
    }else{
        deliveryTime = QDateTime::fromTime_t(order->delivery_time).toString("hh:mm");
        datetime = QDateTime::currentDateTime().toString("MM/dd");
    }

    int allprod = 0;

    foreach(ProductObject* dish,order->proList)
    {
        allprod += dish->product_amount;
    }

    int index = 0;
    foreach(ProductObject* dish,order->proList)
    {
        int num = dish->product_amount;

        while(num > 0)
        {

            QByteArray data = config.toLocal8Bit();

            char *tmpconfig = NULL;

            CONSTCHARTOCHAR(data, tmpconfig);

            if(f_labprtiopen(tmpconfig) != 1)
            {
                QLOG_ERROR() << "NewPrintLib::DoPrint::f_prtopen failed";
                delete [] tmpconfig;
                f_labprtclose();
                return false;
            }
            delete [] tmpconfig;

            QString title = QString(" %2 %4/%5").arg(datetime, QString::number(++index), QString::number(allprod));

            QString tmptitle;
            if(QString("saas").compare(order->channel) == 0)
            {
                if(order->order_type == 3 || order->order_type == 4 || order->order_type == 5)
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE8\x87\xAA\xE6\x8F\x90").append(order->code).append(" ").append(title);
                    tmptitle = QString("\xE8\x87\xAA\xE6\x8F\x90").append(order->code).append(" ").append(title);
                }
                else if(order->order_type == 6)
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE9\xA2\x84\xE7\xBA\xA6").append(order->code).append(" ").append(title);
                    tmptitle = QString("\xE9\xA2\x84\xE7\xBA\xA6").append(order->code).append(" ").append(title);
                }
                else
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE5\xA4\x96\xE5\x8D\x96").append(QString::number(order->order_index)).append(" ").append(title);
                    tmptitle = QString("\xE5\xA4\x96\xE5\x8D\x96").append(QString::number(order->order_index)).append(" ").append(title);
                }
            }
            else
            {
                QString tmpstr = order->channel_name;
                tmptitle = tmpstr.append(QString::number(order->order_index)).append(" ").append(title);;
            }

            QString prodname = dish->name;

            qDebug() << "input9:" << prodname;

            QString configfile = qApp->applicationDirPath() + "/" + CONFIG_NAME;
            QString partnerid = QSettings(configfile, QSettings::IniFormat).value(INI_BASE_PARNETID).toString();

            if(partnerid == SHUYI) {
                f_labprtlinewithsizeandratio(0, 50, 24, 0.0266665, 0, tmptitle.toLocal8Bit().data());
                f_labprtlinewithsizeandratio(0, 0, 24, 0.0266665, 0, "-----------------------------------");
                f_labprtlinewithsizeandratio(0, 0, 24, 0.0266665, 1, prodname.append(QString("\x20\xC2\xA5")).append(QString::number(dish->price/100.0, 'f', 2)).toLocal8Bit().data());
            } else if(partnerid == YIHETANG) {
                f_labprtlinewithsizeandstyle(10, 50, 24, 0, 0, tmptitle.toLocal8Bit().data());
                f_labprtlinewithsizeandstyle(10, 0, 24 ,0 ,0, "-----------------------------------");
                f_labprtlinewithsizeandstyle(10, 0, 32, 2, 1, prodname/*.append(QString("\x20\xC2\xA5")).append(QString::number(dish->price/100.0, 'f', 2))*/.toLocal8Bit().data());
            } else {
                f_labprtline(0, 10, 0, tmptitle.toLocal8Bit().data());
                f_labprtline(0, 0, 0, "-----------------------------------");
                f_labprtline(10, 0, 1, prodname.append(QString("\x20\xC2\xA5")).append(QString::number(dish->price/100.0, 'f', 2)).toLocal8Bit().data());
//                 f_labprtlinewithsizeandstyle(100, 100, 32, 0, 0, (QString("\xE5\x88\x98\xE5\xB8\x85")).toLocal8Bit().data());
//                 f_labprtlinewithsizeandstyle(70, 140, 32, 0, 0, (QString("15290352796").toLocal8Bit().data()));
            }
            QString property_tags;
            if(!dish->property_tags.isEmpty())
            {
                property_tags.append(dish->property_tags);
                property_tags.append(",");
            }
            if(!dish->sub_products.isEmpty())
            {
                foreach(ProductObject* sub_dish,dish->sub_products)
                {
                    property_tags.append(sub_dish->name);
                    property_tags.append(",");
                }
            }
            property_tags.remove(property_tags.length()-1,1);

            if(partnerid == SHUYI) {
                f_labprtlinewithsizeandratio(0,0,24, 0.0266665, 1,property_tags.toLocal8Bit().data());
            } else if(partnerid == YIHETANG) {
                f_labprtlinewithsizeandstyle(10,0,32,2,1,property_tags.toLocal8Bit().data());
            } else {
                f_labprtline(10,0,1,property_tags.toLocal8Bit().data());
            }

            QString sendtimes = QString("");

            if(tmpdelitime != 0 /*&& (order->order_type == 1 || order->order_type == 2)*/)
            {
                sendtimes.append(QDateTime::fromTime_t(order->delivery_time).toString("yyyy-MM-dd hh:mm"));
                if(partnerid == SHUYI) {
                    f_labprtlinewithsizeandratio(0,140,24, 0.0266665, 1,sendtimes.toLocal8Bit().data());
                } else if(partnerid == YIHETANG) {
                    f_labprtlinewithsizeandstyle(10,140,24,0,1,sendtimes.toLocal8Bit().data());
                }else {
                    f_labprtline(10,140,1,sendtimes.toLocal8Bit().data());
                }

            }
            if(partnerid == SHUYI) {
                f_labprtlinewithsizeandratio(0,170,24, 0.0266665, 1,order->store_name.toLocal8Bit().data());
            } else if(partnerid == YIHETANG) {
                f_labprtlinewithsizeandstyle(10,180,24,0,1,order->store_name.toLocal8Bit().data());
            } else {

                f_labprtline(10,180,1,order->store_name.toLocal8Bit().data());
            }

            f_labprtclose();

            -- num;
        }
    }
    return true;
}

bool NewPrintLib::DoBackPrint(int page_depart, int prod_depart, int page_num, const QStringList &stallsprods, const QString &config, const QString &context, OrderObject *order, int page)
{
    if(!_load_flag && !LoadFunction())
    {
        QLOG_ERROR() << "NewPrintLib::DoBackPrint failed";
        return false;
    }

    QLOG_DEBUG() << "GetProdList(stallsprods, order, list)" << stallsprods;

    QStringList list;

    if(GetProdList(stallsprods, order, list) == false)
    {
        QLOG_WARN() << "NewPrintLib::DoBackPrint::GetProdList failed";
        //无需打印
        return true;
    }

    QLOG_DEBUG() << "NewPrintLib::list:" <<list;

    QList<OrderObject> orderlist;

    if(GetObjList(page_depart, prod_depart, list, orderlist, order) == false)
    {
        QLOG_ERROR() << "NewPrintLib::DoBackPrint::GetObjList failed";
        //无需打印
        return true;
    }


    int i = 0; //打印的页数

    while( i < page_num)
    {
        int index = 0;

        while(index < orderlist.size())
        {
//            QByteArray data = config.toUtf8();

//            char *tmpconfig = NULL;

//            CONSTCHARTOCHAR(data, tmpconfig);

//            if(f_prtopen(tmpconfig) != 1)
//            {
//                QLOG_ERROR() << "NewPrintLib::DoPrint::f_prtopen failed";
//                delete [] tmpconfig;
//                f_prtclose();
//                return false;
//            }
//            delete [] tmpconfig;

//            bool result;
//            QString error;
//            PrintDocument doc = PrintDocument::ParseToDocument(context, result, error);
//            if(!result)
//            {
//                f_prtclose();
//                QLOG_ERROR() << "NewPrintLib::DoPrint::PrintDocument::ParseToDocument failed";
//                return false;
//            }

//            OrderObject tmporder = orderlist[index];

//            PrintLineNode(doc, &tmporder);

//            f_prtclose();


            OrderObject tmporder = orderlist[index];

            QLOG_DEBUG() << "input2:" <<  tmporder._orderObject;

            char *prtconfig = NULL;
            QByteArray prtconfigdata = config.toLocal8Bit();

            CONSTCHARTOCHAR(prtconfigdata, prtconfig);

            char *xml = NULL;

            QByteArray xmldata = context.toLocal8Bit();

            CONSTCHARTOCHAR(xmldata, xml);

            char *orderinfo = NULL;

            QJsonObject orderObj = tmporder._orderObject;
            int type = -100;
            if(orderObj.contains("order_type")) {
                type = orderObj["order_type"].toInt();
            }

            QLOG_DEBUG() << "NewPrintLib::type:" << type;

            //桌号设置
            if(orderObj.contains("table_number") && orderObj["table_number"].toString() != "")
            {
                QLOG_DEBUG() << "NewPrintLib::table_number:" << orderObj["table_number"].toString();
                tmporder._orderObject["table_number"] = QString(orderObj["table_number"].toString() + QString::fromLocal8Bit(TABLE_NUMBER));
                QLOG_DEBUG() << "NewPrintLib::new_table_number:" << tmporder._orderObject["table_number"].toString();
            }

            QString channel = orderObj["channel"].toString();

             QLOG_DEBUG() << "NewPrintLib::channel:" << channel;

             QString tableheadname = QApplication::applicationDirPath() + QString("/prtinfo/tablehead.ini");
             QSettings m_setting(tableheadname,QSettings::IniFormat);
             m_setting.setIniCodec("UTF-8");


             if(QString("saas").compare(channel, Qt::CaseInsensitive) == 0)
             {
                 switch(type) {
                 case TimelyTakeout:
                     if(page == 56) {
                         if(m_setting.value("1").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("1").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYTAKEOUT));
                         }
                     } else {
                         if(m_setting.value("5").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("5").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYTAKEOUT));
                         }
                     }
                     break;
                 case AppointmentTakeout:
                     if(page == 56) {
                         if(m_setting.value("7").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("7").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTTAKEOUT));
                         }
                     } else {
                         if(m_setting.value("10").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("10").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTTAKEOUT));
                         }
                     }

                     break;
                 case TimelyDining:
                     if(page == 56) {
                         if(m_setting.value("2").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("2").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                         }
                     } else {
                         if(m_setting.value("6").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("6").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                         }
                     }

                     break;
                 case AppointmentDining:
                     if(page == 56) {
                         if(m_setting.value("8").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("8").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                         }
                     } else {
                         if(m_setting.value("11").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("11").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                         }
                     }

                     break;
                 case TimelyInvite:
                     if(page == 56) {
                         if(m_setting.value("2").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("2").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                         }
                     } else {
                         if(m_setting.value("6").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("6").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
                         }
                     }
                     break;
                 case AppointmentInvite:
                     if(page == 56) {
                         if(m_setting.value("8").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("8").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                         }
                     } else {
                         if(m_setting.value("11").toString() != "") {
                             tmporder._orderObject.insert("source_order_type" , m_setting.value("11").toString());
                         } else {
                             tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
                         }
                     }
                     break;
                 default:
                     break;
                 }
             } else {
                 switch(type) {
                 case TimelyTakeout:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT));
                     break;
                 case AppointmentTakeout:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTTAKEOUT));
                     break;
                 case TimelyDining:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
                     break;
                 case AppointmentDining:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
                     break;
                 case TimelyInvite:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
                     break;
                 case AppointmentInvite:
                     tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
                     break;
                 default:
                     break;
                 }
             }


            //将订单的预约时间拿过来转换成订单需要的QString类型
            int delivery_time = orderObj["delivery_time"].toInt();
            QString prt_delivery_time;
            if(type == 1)
            {
                prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_TAKEOUT);
            }
            else if(type == 3 || type == 5)
            {
                prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_INVITE);
            }
            else
            {
                prt_delivery_time = QDateTime::fromTime_t(delivery_time).toString("yyyy/MM/dd hh:mm:ss");
            }

            tmporder._orderObject.insert("prt_delivery_time", prt_delivery_time);

            QByteArray orderdata = QString(QJsonDocument(tmporder._orderObject).toJson()).toLocal8Bit();
            CONSTCHARTOCHAR(orderdata, orderinfo);

            char err[1024] = {0};   

            f_DoPrintWithXml(prtconfig, orderinfo, xml,  err);

            if(strlen(err) > 0)
            {
                QLOG_ERROR() << "f_DoPrintWithXml failed error : " << err;
            }

            delete [] prtconfig;
            delete [] xml;
            delete [] orderinfo;

            QLOG_DEBUG() << "f_DoPrintWithXml success";


            Sleep(200);

            ++ index;
        }
        ++ i;
    }
    return true;
}

bool NewPrintLib::DoLabelPrint(const QString &config, OrderObject *order)
{
    if(!_load_flag && !LoadFunction())
    {
        QLOG_ERROR() << "NewPrintLib::DoLabelPrint failed";
        return false;
    }

    return PrintLabel(config, order);
}

bool NewPrintLib::DoLabelModelPrint(const QString &config, const QString &context, OrderObject *order)
{
    OrderObject tmporder = *order;

    QLOG_DEBUG() << "input1:" <<  tmporder._orderObject;

    if(!_load_flag && !LoadFunction())
    {
        QLOG_ERROR() << "NewPrintLib::DoPrint failed";
        return false;
    }

    char *prtconfig = NULL;
    QByteArray prtconfigdata = config.toLocal8Bit();

    CONSTCHARTOCHAR(prtconfigdata, prtconfig);

    char *xml = NULL;

    QByteArray xmldata = context.toLocal8Bit();

    CONSTCHARTOCHAR(xmldata, xml);

    char *orderinfo = NULL;

    //根据订单号填写打印模板的表头
    QJsonObject orderObj = tmporder._orderObject;
    int type = -100;
    if(orderObj.contains("order_type")) {
        type = orderObj["order_type"].toInt();
    }

    QLOG_DEBUG() << "NewPrintLib::type:" << type;

    //表头设置
    QString channel = orderObj["channel"].toString();

     QLOG_DEBUG() << "NewPrintLib::channel:" << channel;

     QString source_order_desc;

    if(QString("saas").compare(channel, Qt::CaseInsensitive) == 0)
    {
        switch(type) {
        case TimelyTakeout:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYTAKEOUT));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT);
            break;
        case AppointmentTakeout:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTTAKEOUT));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT);
            break;
        case TimelyDining:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case AppointmentDining:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case TimelyInvite:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_TIMELYINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case AppointmentInvite:
            tmporder._orderObject.insert("source_order_type" , QString::fromLocal8Bit(ORDER_TYPE_APPOINTMENTINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        default:
            break;
        }
    } else {
        switch(type) {
        case TimelyTakeout:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT);
            break;
        case AppointmentTakeout:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTTAKEOUT));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYTAKEOUT);
            break;
        case TimelyDining:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case AppointmentDining:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case TimelyInvite:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        case AppointmentInvite:
            tmporder._orderObject.insert("source_order_type" , channel + QString::fromLocal8Bit(ORDER_THIRD_APPOINTMENTINVITE));
            source_order_desc = QString::fromLocal8Bit(ORDER_THIRD_TIMELYINVITE);
            break;
        default:
            break;
        }
    }


    //将订单的预约时间拿过来转换成订单需要的QString类型
    int delivery_time = orderObj["delivery_time"].toInt();
    QLOG_DEBUG() << "prt_type" << type;
    QString prt_delivery_time;
    QString inviteTime;
    if(type == 1)
    {
        prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_TAKEOUT);
        inviteTime = "";
    }
    else if(type == 3 || type == 5)
    {
        prt_delivery_time = QString::fromLocal8Bit(PRT_DELIVERY_TIME_INVITE);
        inviteTime = "";
    }
    else
    {
        prt_delivery_time = QDateTime::fromTime_t(delivery_time).toString("yyyy/MM/dd hh:mm:ss");
        inviteTime = QString::fromLocal8Bit(INVITETIME) + QDateTime::fromTime_t(delivery_time).toString("MM-dd hh:mm");
    }

    tmporder._orderObject.insert("prt_delivery_time", prt_delivery_time);


    QLOG_DEBUG() << "NewNew tmporder._orderObject :" << tmporder._orderObject;
    QByteArray orderdata = QString(QJsonDocument(tmporder._orderObject).toJson()).toLocal8Bit();
    CONSTCHARTOCHAR(orderdata, orderinfo);


    //! TODO 解析遍历商品，杯贴打印单个商品，并且打印商品序列、商品名、单价、配料 下单时间 门店
    //! 解析出来的数据重新组装orderinfo，再调f_DoLabPrintWithXml，一个一个商品打印

    QLOG_DEBUG() << "-----------------1------------------------";
    QString deliveryTime;
    QString datetime;

    int tmpdelitime = order->srcdlv_time;

    if(order->delivery_time==0)
    {
        deliveryTime = QDateTime::currentDateTime().toString("hh:mm");
        datetime = QDateTime::currentDateTime().toString("MM/dd");
    }else{
        deliveryTime = QDateTime::fromTime_t(order->delivery_time).toString("hh:mm");
        datetime = QDateTime::currentDateTime().toString("MM/dd");
    }
    QLOG_DEBUG() << "-----------------2------------------------";

    int allprod = 0;

    foreach(ProductObject* dish,order->proList)
    {
        allprod += dish->product_amount;
    }
    QLOG_DEBUG() << "-----------------3------------------------";

    int index = 0;
    foreach(ProductObject* dish,order->proList)
    {
        QLOG_DEBUG() << "-----------------4------------------------";
        int num = dish->product_amount;

        while(num > 0)
        {

            QString title = QString(" %2 %4/%5").arg(datetime, QString::number(++index), QString::number(allprod));

            QString tmptitle;
            if(QString("saas").compare(order->channel) == 0)
            {
                if(order->order_type == 3 || order->order_type == 4 || order->order_type == 5)
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE8\x87\xAA\xE6\x8F\x90").append(order->code).append(" ").append(title);
                    tmptitle = QString("\xE8\x87\xAA\xE6\x8F\x90").append(order->code).append(" ").append(title);
                }
                else if(order->order_type == 6)
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE9\xA2\x84\xE7\xBA\xA6").append(order->code).append(" ").append(title);
                    tmptitle = QString("\xE9\xA2\x84\xE7\xBA\xA6").append(order->code).append(" ").append(title);
                }
                else
                {
//                    tmptitle = QString("\xE9\x9D\x9E\xE7\xA0\x81\xE5\xA4\x96\xE5\x8D\x96").append(QString::number(order->order_index)).append(" ").append(title);
                    tmptitle = QString("\xE5\xA4\x96\xE5\x8D\x96").append(QString::number(order->order_index)).append(" ").append(title);
                }
            }
            else
            {
                QString tmpstr = order->channel_name;
                tmptitle = tmpstr.append(QString::number(order->order_index)).append(" ").append(title);;
            }

            QString prodname = dish->name;

            qDebug() << "input9:" << prodname;

            QString property_tags;
            if(!dish->property_tags.isEmpty())
            {
                property_tags.append(dish->property_tags);
                property_tags.append(",");
            }
            if(!dish->sub_products.isEmpty())
            {
                foreach(ProductObject* sub_dish,dish->sub_products)
                {
                    property_tags.append(sub_dish->name);
                    property_tags.append(",");
                }
            }
            property_tags.remove(property_tags.length()-1,1);

            QString sendtimes = QString("");

            if(tmpdelitime != 0 /*&& (order->order_type == 1 || order->order_type == 2)*/)
            {
                sendtimes.append(QDateTime::fromTime_t(order->delivery_time).toString("MM-dd hh:mm"));
            }

            //匹配杯贴打印模板,组装新的数据对象
            QJsonObject prdObj;
//            prdObj.insert("prt_title", tmptitle);
//            prdObj.insert("prt_singleproduct", prodname.append(QString("\x20\xC2\xA5")).append(QString::number(dish->price/100.0, 'f', 2)));
//            prdObj.insert("prt_property", property_tags);
//            prdObj.insert("prt_sendtimes", sendtimes);
//            prdObj.insert("prt_store", order->store_name);
            prdObj.insert("code", QString("\xE3\x80\x90") + order->code + QString("\xE3\x80\x91"));
            prdObj.insert("order_index", QString::fromLocal8Bit("#") + QString::number(order->order_index));
            prdObj.insert("order_type_desc", order->order_type_desc);
            prdObj.insert("source_order_desc", source_order_desc);
            prdObj.insert("datetime", datetime);
            prdObj.insert("current_index", index);
            prdObj.insert("allprod_num", allprod);
            prdObj.insert("prod_name", prodname);
            prdObj.insert("prod_price", QString("\xEF\xBF\xA5") + QString::number(dish->price/100.0, 'f', 2));
            prdObj.insert("property_tags", property_tags);
            prdObj.insert("sendtimes", inviteTime);
            prdObj.insert("store_name", order->store_name);

            char *singlePrdPrt = NULL;

            QByteArray singlePrd = QString(QJsonDocument(prdObj).toJson()).toLocal8Bit();
            CONSTCHARTOCHAR(singlePrd, singlePrdPrt);

            char err[1024] = {0};

            qDebug() << "input singleprdprt:" << singlePrdPrt;

            f_DoLabPrintWithXml(prtconfig, singlePrdPrt, xml,  err);

            if(strlen(err) > 0)
            {
                QLOG_ERROR() << "f_DoPrintWithXml failed error : " << err;
            }

            delete [] singlePrdPrt;

            -- num;
        }
    }

    QLOG_DEBUG() << "-----------------5------------------------";

    delete [] prtconfig;
    delete [] xml;

    QLOG_DEBUG() << "f_DoPrintWithXml success";

    return true;
}

bool NewPrintLib::LoadFunction()
{
    QLibrary lib;

    lib.setFileName(qApp->applicationDirPath() + "/" + "PrtLib.dll");

    if(!lib.load())
        return false;

    f_unloaddll = (Unloaddll)lib.resolve("Unloaddll");
    f_loadaddress = (LoadAddress)lib.resolve("LoadAddress");
    f_labprtiopen = (LabPrtOpen)lib.resolve("LabPrtOpen");
    f_labprtline = (LabPrtLine)lib.resolve("LabPrtLine");
    f_labprtlinewithsizeandratio = (LabPrtLineWithSizeAndRatio)lib.resolve("LabPrtLineWithSizeAndRatio");
    f_labprtlinewithsizeandstyle = (LabPrtLineWithSizeAndStyle)lib.resolve("LabPrtLineWithSizeAndStyle");
    f_labprtclose = (LabPrtClose)lib.resolve("LabPrtClose");
    f_prtopen = (PrtOpen)lib.resolve("PrtOpen");
    f_prtclose = (PrtClose)lib.resolve("PrtClose");
    f_freeline = (FreeLine)lib.resolve("FreeLine");
    f_printdataline = (PrintDataLine)lib.resolve("PrintDataLine");
    f_printBarcode = (PrintBarCode)lib.resolve("PrintBarCode");
    f_printqrcode = (PrintQRCode)lib.resolve("PrintQRCode");
    f_DoPrintWithXml = (DoPrintWithXml)lib.resolve("DoPrintWithXml");
    f_DoLabPrintWithXml = (DoLabPrintWithXml)lib.resolve("DoLabPrintWithXml");

    if(!(f_unloaddll && f_loadaddress && f_labprtiopen && f_labprtline && f_labprtlinewithsizeandratio && f_labprtlinewithsizeandstyle
            && f_labprtclose && f_prtopen && f_prtclose && f_freeline
            && f_printdataline && f_printBarcode && f_printqrcode && f_DoPrintWithXml))
    {
        QLOG_ERROR()<<"NewPrintLib::LoadFunction failed!";
        _load_flag = false;
    }

    if(f_loadaddress())
        _load_flag = true;
    else
        _load_flag = false;


    return _load_flag;
}

