#ifndef FMP_DATABASE_H
#define FMP_DATABASE_H

#include <QObject>
#include <QSqlDatabase>

#include "preDefine.h"

class FMPLoggerInterface;
class QSqlQuery;
class QSqlDatabase;

class FMDataBase : public QObject
{
    Q_OBJECT
public:
    FMDataBase(QString dbname, QString connectname = QString(DEFAULT_CONNECTNAME), QObject *parent = 0);

    ~FMDataBase();

    bool insert(QString table, QVariantHash data);

    bool insert(QString table, QVariantMap data);

    bool update(QString table, QVariantHash data, QString condition);

    bool update(QString table, QVariantMap data, QString condition);

    bool find(QString table, QSqlQuery &query, QStringList keylist = QStringList(), QString condition = QString(""));

    bool creat(QString sql, QString tablename);

    bool dlt(QString table, QString condition);

    QSqlDatabase getDb() const;

private:

    bool exist(QString table);

    bool getSql(QString table, QVariantHash data, QString &sql);

    bool getSql(QString table, QVariantMap data, QString &sql);

    bool getSql(QString table, QVariantHash data, QStringList &columnnamelist, QStringList &columnvaluelist);

    bool getSql(QString table, QVariantMap data, QStringList &columnnamelist, QStringList &columnvaluelist);

private:

    QSqlDatabase _db;

    bool _isopen;
};

#endif // FMP_DATABASE_H
