#include "fm_database.h"

#include <QDebug>
#include <QSqlError>
#include <QSqlQuery>
#include <QVariantHash>
#include <QSqlQueryModel>
#include "QsLog.h"

FMDataBase::FMDataBase(QString dbname, QString connectname, QObject *parent) : QObject(parent)
{
    if (!QSqlDatabase::contains(connectname)) {
        _db = QSqlDatabase::addDatabase("QSQLITE", connectname);
    }
    else {
        _db = QSqlDatabase::database(connectname);
    }
    _db.setDatabaseName(dbname);   
    _isopen = _db.open();
}

FMDataBase::~FMDataBase()
{
    if(_isopen)
        _db.close();
}

bool FMDataBase::creat(QString sql, QString tablename)
{
    if(!_isopen)
        return false;

    QSqlQuery query(_db);

    query.exec(QString("select count(*) from sqlite_master where type='table' and name='%1'").arg(tablename));

    int isTableExist = 0;

    if(!query.next())
        return false;

    isTableExist = query.value(0).toInt();

    if(isTableExist != 0)
        return true;

    bool flag = query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::dlt(QString table, QString condition)
{
    if(!_isopen)
        return false;

    QString sql = QString("delete from %1 where %2").arg(table, condition);

    QSqlQuery query(_db);

    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::insert(QString table, QVariantHash data)
{
    if(!_isopen)
        return false;

    QString sql;
    QStringList columnnamelist;
    QStringList columnvaluelist;

    if(!getSql(table, data, columnnamelist, columnvaluelist))
    {
        _db.close();
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("insert into %1 (").arg(table) + columnnamelist.join(", ") + ") values (" + columnvaluelist.join(", ") + ")";

    QLOG_DEBUG() << "inset sql : " << sql;

    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::insert(QString table, QVariantMap data)
{
    QLOG_DEBUG() << "FMDataBase::insert _isopen:" << _isopen;
    if(!_isopen)
        return false;

    QString sql;
    QStringList columnnamelist;
    QStringList columnvaluelist;

    if(!getSql(table, data, columnnamelist, columnvaluelist))
    {
        _db.close();
        QLOG_DEBUG() << "FMDataBase::insert getSql failed";
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("insert into %1 (").arg(table) + columnnamelist.join(", ") + ") values (" + columnvaluelist.join(", ") + ")";

    QLOG_DEBUG() << "inset sql : " << sql;

    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::update(QString table, QVariantHash data, QString condition)
{
    if(!_isopen)
        return false;

    QString sql;

    if(!getSql(table, data, sql))
    {
         _db.close();
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("update %1 set ").arg(table) + sql + " where " + condition;

    QLOG_DEBUG() << "update sql : " << sql;

    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::update(QString table, QVariantMap data, QString condition)
{
    if(!_isopen)
        return false;

    QString sql;

    if(!getSql(table, data, sql))
    {
         _db.close();
        return false;
    }

    QSqlQuery query(_db);

    sql = QString("update %1 set ").arg(table) + sql + " where " + condition;

    QLOG_DEBUG() << "update sql : " << sql;

    bool flag =  query.exec(sql);

    if(!flag)
        QLOG_ERROR() << query.lastError();

    return flag;
}

bool FMDataBase::find(QString table, QSqlQuery &query, QStringList keylist, QString condition)
{
    if(!_isopen)
        return false;

    QSqlQuery tmpquery(_db);

    QString sql = "select ";
    if(keylist.size() != 0)
        sql += keylist.join(", ");
    else
        sql += "*";

    if(condition == "")
        condition = "1=1";

    sql += QString(" from %1 where ").arg(table) + condition;

    QLOG_DEBUG() << "find sql : " << sql;

    bool flag =  tmpquery.exec(sql);

    if(!flag)
        QLOG_ERROR() << tmpquery.lastError();

    query = tmpquery;

    return flag;
}

bool FMDataBase::getSql(QString table, QVariantHash data, QStringList& columnnamelist, QStringList& columnvaluelist)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
              columnnamelist.append(columnname);
              columnvaluelist.append(QString("'") + data.value(columnname).toString() + "'");

        }
        continue ;
    }


    if(columnnamelist.size() == 0)
        return false;
    return true;
}

bool FMDataBase::getSql(QString table, QVariantMap data, QStringList& columnnamelist, QStringList& columnvaluelist)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
              columnnamelist.append(columnname);
              columnvaluelist.append(QString("'") + data.value(columnname).toString() + "'");

        }
        continue ;
    }


    if(columnnamelist.size() == 0)
        return false;
    return true;
}

QSqlDatabase FMDataBase::getDb() const
{
    return _db;
}

bool FMDataBase::getSql(QString table, QVariantHash data, QString& sql)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    QStringList list;

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
            list.append(columnname + " = '" + data.value(columnname).toString() + "'");
        }
        continue ;
    }


    if(list.size() == 0)
        return false;

    sql = list.join(", ");

    return true;
}

bool FMDataBase::getSql(QString table, QVariantMap data, QString& sql)
{
    QSqlQuery query(_db);

    QString tmpsql = QString("PRAGMA table_info(%1)").arg(table);
    query.exec(tmpsql);

    QStringList list;

    while(query.next())
    {
        QString columnname = query.value(1).toString();

        if(data.contains(columnname))
        {
            list.append(columnname + " = '" + data.value(columnname).toString() + "'");
        }
        continue ;
    }


    if(list.size() == 0)
        return false;

    sql = list.join(", ");

    return true;
}
