﻿#ifndef CONFIGMANGER_H
#define CONFIGMANGER_H

#include <QSettings>
#include <QUrl>
#include <QPoint>

class ConfigManger
{
public:
    // 数据库连接信息
    typedef struct
    {
        QString host;
        QString username;
        QString password;
        QString database;
    }SqlConnectInfo;

public:
    void GetStoreInfo(QString& storeId, QString& posNo, QString& cashierId, QString &password);
    static ConfigManger& GetInstance();

    /* 功能:获取数据库连接信息
     * 参数:NULL
     * 返回:连接信息
     * */
    SqlConnectInfo GetSqlConnectInfo();
    /* 功能:设置数据库连接信息
     * 参数:连接信息
     * 返回:NULL
     * */
    void SetSqlConnectInfo(const SqlConnectInfo& info);
    /* 功能:读取服务器地址
     * 参数:NULL
     * 返回:服务器地址
     * */
    QUrl GetServerUrl();
    /* 功能:读取打印机名称
     * 参数:NULL
     * 返回:服务器地址
     * */
    QString GetPrinterName();
    /* 功能:设置打印机名称
     * 参数:打印机名称
     * 返回:NULL
     * */
    void SetPrinterName(const QString& printer);
    /* 功能:读取悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    QPoint GetFloatInitPostion();
    /* 功能:设置悬浮窗坐标
     * 参数:NULL
     * 返回:服务器地址
     * */
    void setFloatInitPostion(const QPoint& postion);
    /* 功能:获取悬浮窗闪烁间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetBlinkInterval();
    /* 功能:获取播放声音间隔时长
     * 参数:NULL
     * 返回:间隔时长
     * */
    int GetSoundInterval();
    /* 功能:获取是否存在[重新补单]
     * 参数:NULL
     * 返回:true存在false不存在
     * */
    bool GetIsExistReEntryOrder();
    /* 功能:获取TCP监听端口
     * 参数:NULL
     * 返回:端口号
     * */
    int GetTcpServerPort();
    /* 功能:获取销售单写入地址
     * 参数:NULL
     * 返回:销售单地址
     * */
    QString GetDbServerIp();
    /* 功能:获取销售单写入端口
     * 参数:NULL
     * 返回:销售单端口
     * */
    int GetDbServerPort();
    /* 功能:获取是否自动接单
     * 参数:NULL
     * 返回:1自动，0手动
     * */
    int GetAutoconfirm();
    /* 功能:获取是否显示界面
     * 参数:NULL
     * 返回:1显示，0不显示
     * */
    int GetUiVisible();
    int GetUdpPort();
    QString GetUdpUrl();

private:
    ConfigManger();
    ConfigManger(ConfigManger const&);
    ConfigManger& operator=(ConfigManger const&);

private:
    // 程序配置和用户配置
    QSettings *m_config;
    QSettings *m_userConfig;
};

#endif // CONFIGMANGER_H
