#include "util.h"
#include "preDefine.h"

QString Penny2Dollar(int penny)
{
    double dollar = (double)penny/100;
    return QString::number(dollar,'f',2);
}

QString GetOperByStatus(int status, bool bRefuse)
{
    switch(status)
    {
    case 1:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATION_REFUSE);
        }
        return QString::fromLocal8Bit(OPERATION_GETDELIVERS);
        break;
    case 2:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATION_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATION_MAKEOVER);
        break;
    case 5:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATION_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATION_SENDOUT);
        break;
    case 4:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATION_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATION_COMPLETE);
        break;
    case 6:
    case 200:
        return "NULL";
        break;
    case 20:
    case 22:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATION_REFUSEREFUND);
        }
        return QString::fromLocal8Bit(OPERATION_REFUNDORDER);
        break;
    default:
        return "NULL";
        break;
    }
}

QString GetOperNameByStatus(int status, bool bRefuse)
{
    switch(status)
    {
    case 1:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUSE);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_GETDELIVERS);
        break;
    case 2:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_MAKEOVER);

        break;
    case 5:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_COMPLETE);
        break;
    case 4:
        if(bRefuse)
        {
            return  QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_COMPLETE);
        break;
    case 6:
    case 200:
        return "NULL";
        break;
    case 20:
    case 22:
        if(bRefuse)
        {
            return QString::fromLocal8Bit(OPERATIONNAME_REFUSEREFUND);
        }
        return QString::fromLocal8Bit(OPERATIONNAME_REFUNDORDER);
        break;
    default:
        return "NULL";
        break;
    }
}
