﻿#ifndef CRETOPT
#define CRETOPT

#include "dataprocess.h"

#include <string>
#include <QFile>
#include <QString>
#include <QJsonObject>
#include <QJsonDocument>
#include <QMutex>
#include "QsLog.h"

#include "preDefine.h"

class CretOperate
{
public:
//    static bool RSASign(QJsonObject &json, QString &sign)
//    {
//        return true;
//    }

    static bool GetSign(QJsonObject &json, QString &sign = QString())
    {
        QStringList list;
        QString values;

        DataProcess::GetJsonKeyArray(list, json);
        DataProcess::SortString(list);
        DataProcess::GetValueFromJson(list, json, values);

        QByteArray array = values.toUtf8();

        QLOG_INFO() << "sign list : " << array;

        char tmp[MAX_SIGN_LEN] = { 0 };

        s_RSAlock.lock();
        if(DataProcess::RSASign(array.data(), tmp, MAX_SIGN_LEN, SHA256RSA_PRIVATEKEY) == 0)
        {
            QLOG_ERROR() << "get RSASign failed";
            return false;
        }
        s_RSAlock.unlock();

        QLOG_INFO() << "get RSA sign:" << tmp;

        std::string tmpsing = std::string(tmp);

        std::string stdtmpsing = DataProcess::UrlEncode(tmpsing);

        sign = QString::fromStdString(stdtmpsing);

        QLOG_INFO() << "encode url sign :" << sign;

        return true;
    }

private:
    static QMutex s_RSAlock;
};

#endif // CRETOPT

