﻿#ifndef PRODUCTOBJECT_H
#define PRODUCTOBJECT_H

#include "baseObject.h"

class ProductObject : public BaseObject
{
    Q_OBJECT
public:
    ProductObject(QObject *parent=0)
        :BaseObject(parent){}
    ProductObject(const ProductObject& p,QObject *parent=0);
    ProductObject &operator =(const ProductObject& p);
    void FromJson(const QJsonObject& json);

    Q_PROPERTY (QString property_tags READ getproperty_tags WRITE setproperty_tags)
    Q_PROPERTY (QString pid READ getPid WRITE setPid)
    Q_PROPERTY (QString name READ getName WRITE setName)
    Q_PROPERTY (QString upc READ getupc WRITE setupc)
    Q_PROPERTY (int price READ getprice WRITE setprice)
    Q_PROPERTY (int productAmount READ getProductAmount WRITE setProductAmount)
    Q_PROPERTY (int cost READ getcost WRITE setcost)

    QString property_tags;
    QString pid;
    QString name;
    QString upc;
    int price;
    int productAmount;
    QList<ProductObject*> sub_products;//子商品
        int cost;                //是否是优惠卷

protected:

    int getcost() const{
        return cost;
    }
    void setcost(const int & v){
        cost = v;
    }
    QString getPid() const ;
    void setPid(const QString& v);

    QString getproperty_tags() const ;
    void setproperty_tags(const QString& v);

    QString getName() const ;
    void setName(const QString& v);

    QString getupc() const ;
    void setupc(const QString& v);

    int getprice() const ;
    void setprice(const int& v);

    int getProductAmount() const ;
    void setProductAmount(const int &v);
};

#endif // PRODUCTOBJECT_H
