#ifndef FM_CONTROL_H
#define FM_CONTROL_H

#include <QObject>
#include <QByteArray>
#include <QString>

class NetWork;

class control : public QObject
{
    Q_OBJECT
public:
    explicit control(QObject *parent = 0);

    void start();

    static bool checkbaseinfo(std::string &data, std::string &error);

    bool setbaseinfo(std::string data, int reqtype, std::string &error, bool &isbaseinfo);

    bool getreqtype(std::string data, int &reqtype, std::string &error);

    bool getcomplejson(std::string srcdata, std::string &compledata, std::string &error);

    bool senddatatoserver(std::string data, std::string &outdata, std::string &error, int reqtype);

    void checkneedrollback(std::string data, int reqtype);

    void checkneedrollback();

    bool AddSigntoJson(int reatype, std::string &data, std::string &error);

    bool getrealurl(QString &url, int reqtype);

    ~control();

    void swap_and_send_data(std::string compledata, int reqtype);

    void swap_data(std::string compledata, int reqtype);

    void loadbaseinfo();

    bool compressjson(std::string &data);

    bool checkneedhead(QByteArray &data);

    static bool addmessage(std::string &data);

    void addordernumber(std::string &data);
signals:

public slots:
    void recv_data_pos(QByteArray data);

    void recv_error_pos(QString error);

private:
    NetWork *_network;

    std::string _baseinfo;

    bool _isrollbacking;
};

#endif // CONTROL_H
