#ifndef FM_NETWORK_H
#define FM_NETWORK_H

#include <QObject>
#include <QTcpServer>
#include <QTcpSocket>
#include <QByteArray>
#include <QString>

/**********************************************
 * one NetWork object allow one connect working
***********************************************/

typedef struct
{
    unsigned int flag;
    unsigned int ver;
    unsigned int len;
} fm_socket_head;

class NetWork : public QObject
{
    Q_OBJECT
public:
    explicit NetWork(QObject *parent = 0);

    ~NetWork();

    //start listen port
    bool listen(unsigned int port, QString &error);

    bool senddata(QByteArray array);

    void closeconnection();

    static bool HttpPost(QString url, QByteArray indata, QByteArray &outdata, QString &error, unsigned int timeout = 60);


signals:
    void recv_data_ready(QByteArray data);

    void error_throw(QString error);

public slots:
    void on_new_connection_come();

private:
    //tcp server
    QTcpServer *_tcpserver;
    //active socket(only one)
    QTcpSocket *_active_skt;
};

#endif // NETWORK_H
