#include <QCoreApplication>
#include <QDebug>
#include <QDir>
#include "QsLog.h"
#include "config.h"
#include "control.h"
#include "refreshxmlwork.h"

#ifdef FM_TEST

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    QString logDir = QString("%1/log").arg(QCoreApplication::applicationDirPath());
    QDir().mkdir(logDir);

    QsLogging::Logger &logger = QsLogging::Logger::instance();
    logger.setLoggingLevel(QsLogging::TraceLevel);
    QString logPath = QString("%1/%2").arg(logDir, "fmcoupon.log");
    QsLogging::DestinationPtr fileDst(QsLogging::DestinationFactory::MakeFileDestination(
    logPath, QsLogging::EnableLogRotation, QsLogging::MaxSizeBytes(2*1024*1024), QsLogging::MaxOldLogCount(10)));
    logger.addDestination(fileDst);
    QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consleDest);

    RefreshXmlWork work;
    work.start();

    control con;
    con.start();


//    //NetWork net;

//    //QString error;
//    //QByteArray outdata;

//    //bool flag = net.listen(38888, error);

//    //QLOG_INFO() << flag << error;

//    //bool falg = NetWork::HttpPost(QString("http://172.16.13.48:9090"), "meximexi", outdata, error, 60);

//    //QLOG_INFO() << falg << error << outdata;

//    std::string src = "{\"code\":\"1231231231\"}", des, key, value, error;

//    QLOG_INFO() << src.data();


//    bool flag = fm_xmltojson::JsonConvertFront(src, des, key, value, error);

//    QLOG_INFO() << "JsonConvertFront end " << flag << error.data();

    return a.exec();
}

#else

#include<QDebug>

#include <rapidjson/document.h>
#include <rapidjson/prettywriter.h>
#include <rapidjson/filereadstream.h>
#include <rapidjson/filewritestream.h>
#include <rapidjson/stringbuffer.h>
#include <rapidjson/writer.h>
#include "fm_xmltojson.hpp"

int main(int argc, char *argv[])
{

    QCoreApplication a(argc, argv);

    QString logDir = QString("%1/log").arg(QCoreApplication::applicationDirPath());
    QDir().mkdir(logDir);

    QsLogging::Logger &logger = QsLogging::Logger::instance();
    logger.setLoggingLevel(QsLogging::TraceLevel);
    QString logPath = QString("%1/%2").arg(logDir, "fmconpon.log");
    QsLogging::DestinationPtr fileDst(QsLogging::DestinationFactory::MakeFileDestination(
    logPath, QsLogging::EnableLogRotation, QsLogging::MaxSizeBytes(2*1024*1024), QsLogging::MaxOldLogCount(10)));
    logger.addDestination(fileDst);
    QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consleDest);

    {
        std::string strIn = std::string("{\"business_date\":\"20200803\",\"operator_id\":\"admin\",\"pos_id\":\"CN0101000\",\"store_id\":\"CN0101000\",\"partner_id\":1400,\"fm_cmd\":10032,\"trans_id\":\"201802020001\",\"order_amount\":13600,\"coupon\":\"943093287143765437\",\"products\":[{\"seq\":\"1\",\"pid\":\"XXXXXXXXX\",\"name\":\"商品A\",\"price\":5100,\"qty\":2,\"sub_items\":[{\"name\":\"珍珠\",\"price\":100,\"qty\":1},{\"name\":\"椰果\",\"price\":100,\"qty\":1}]},{\"seq\":\"2\",\"pid\":\"YYYYYYYYY\",\"name\":\"商品B\",\"price\":3000,\"qty\":1}]}");
        std::string strOut;
        std::string key;
        std::string value;
        std::string error;

        if(!fm_xmltojson::JsonConvertFront(strIn, strOut, key, value, error))
        {
            QLOG_ERROR() << "#JsonConvertPost failed" << error.data();
        }
        QLOG_INFO() << "#strOut" << strOut.data();
        QLOG_INFO() << "#key" << key.data();
        QLOG_INFO() << "#value" << value.data();
        QLOG_INFO() << "#error" << error.data();

    }

    {
        std::string strIn = std::string("{\"couponOrderInfo\":{\"originalPrice\":1100.00,\"salePrice\":800.00},\"ebCode\":\"0000000973\",\"ebName\":\"A11\",\"orderInfo\":{\"activeCode\":\"P140020200703102620\",\"activeName\":\"zznc\",\"amountPaid\":0,\"discountOrderProducts\":[{\"lineNumber\":1,\"merchantDiscountPrice\":400,\"otherDiscountPrice\":0,\"platformDiscountPrice\":800,\"productNumber\":\"CNAAAACAA\",\"quantity\":1}],\"totalMerchantDiscount\":400,\"totalOtherDiscount\":0,\"totalPlatformDiscount\":800,\"voucherType\":0},\"originResultCode\":\"1\",\"productLimit\":0,\"requestAccount\":\"1400\",\"resultCode\":\"69\",\"signParam\":\"3440EAE916DFA142113E1FCF19700355\",\"storeNumber\":\"CN0101000\",\"transId\":\"202008030002002\",\"voucherNumber\":\"86613483097985697640\"}");
        std::string strOut;
        std::string key = std::string("fm_cmd");
        std::string value = std::string("10039");
        std::string error;


        if(!fm_xmltojson::JsonConvertPost(strIn, strOut, key, value, error))
        {
            QLOG_ERROR() << "JsonConvertPost failed" << error.data();
        }
        QLOG_INFO() << "strOut" << strOut.data();

    }


    {
            rapidjson::Document s;

            s.Parse<0>("{}");

            QLOG_INFO() << "s.IsObject()" << s.IsObject();
            QLOG_INFO() << "s.GetObject().MemberCount()" << s.GetObject().MemberCount();

            rapidjson::Document s1;

            s1.Parse<0>("{\"test\":1}");

            QLOG_INFO() << "s1.IsObject()" << s1.IsObject();
            QLOG_INFO() << "s1.GetObject().MemberCount()" << s1.GetObject().MemberCount();

            return 0;
    }


    {
        std::string msg("{\"status_code\":100}");

        bool flag = control::addmessage(msg);

        QLOG_INFO() << "flag" << flag << QString::fromUtf8(msg.data());

    }

    {
        std::string msg("{\"status_code\":100,\"msg\":\"test\"}");

        bool flag = control::addmessage(msg);

        QLOG_INFO() << "flag" << flag << QString::fromUtf8(msg.data());
    }

    {
        std::string msg("{\"status_code\":\"100\"}");

        bool flag = control::addmessage(msg);

        QLOG_INFO() << "flag" << flag << QString::fromUtf8(msg.data());
    }

    std::string data, data1, error;


    data = "{\"fm_cmd\":1000,\"business_date\":\"2020\",\"operator_id\":\"123123\",\"pos_id\":\"1231\",\"store_id\":\"123\",\"partner_id\":\"6666\"}";


    bool flag = control::checkbaseinfo(data, error);

    QLOG_INFO() << "flag" << flag << QString::fromUtf8(data.data());


    data1 = "{\"fm_cmd\":1000,\"business_date\":\"2020\",\"operator_id\":\"123123\",\"pos_id\":\"1231\",\"store_id\":\"123\"}";

    bool flag1 = control::checkbaseinfo(data1, error);
    QLOG_INFO() << "flag1" << flag1 << QString::fromUtf8(data1.data());


    RefreshXmlWork work;

    work.start();
}
#endif
