#ifndef FM_TOOL_H
#define FM_TOOL_H
#include <QCoreApplication>
#include <QCryptographicHash>
#include <QString>
#include <QSettings>
#include <QVariant>
#include <QFile>
#include <QCryptographicHash>

#include "config.h"



class Tool
{
public:
    static QVariant ReadCfg(QString section, QVariant defaultvalue = QVariant())
    {
        QString cfgfilepath = qApp->applicationDirPath() + QString("/") + QString(CFG_FILEMAE);
        return QSettings(cfgfilepath, QSettings::IniFormat).value(section, defaultvalue);
    }

    static void SetCfg(QString section, QString value)
    {
        QString cfgfilepath = qApp->applicationDirPath() + QString("/") + QString(CFG_FILEMAE);
        QSettings(cfgfilepath, QSettings::IniFormat).setValue(section, QVariant(value));
    }


   static void GetMD5(std::string src, std::string &des)
   {
       QByteArray data = QCryptographicHash::hash(QByteArray(src.data()), QCryptographicHash::Md5);
       des = std::string(data.toHex().toUpper().data());
   }

   static QString FileMd5(const QString &filepath)
   {
        QFile file(filepath);

        qint64 filesize = file.size();
        const qint64 size = 4096;

        if(file.open(QFile::ReadOnly))
        {
            char buffer[4096];
            int byteRead;
            qint64 readsize = qMin(filesize, size);

            QCryptographicHash hash(QCryptographicHash::Md5);

            while(readsize > 0 && (byteRead = file.read(buffer, readsize)) > 0)
            {
                filesize -= byteRead;
                hash.addData(buffer, byteRead);
                readsize = qMin(filesize, size);
            }

            file.close();
            return QString(hash.result().toHex());
        }
        return QString();
   }

};

#endif // TOOL_H
