#ifndef REFRESHXMLWORK_H
#define REFRESHXMLWORK_H

#include <QObject>
#include <QFile>
#include <QNetworkReply>

class RefreshXmlWork : public QObject
{
    Q_OBJECT
public:
    explicit RefreshXmlWork(QObject *parent = 0);
public:
    void start();
    bool getrefreshxml(QString &host, QString &downloadxmlpath, QString &md5);
    bool downloadxml(const QString &path, const QString &md5, QString &localfilename);
    void appliedcxml(QString &localfilename);
    bool request(const QByteArray &data, QByteArray &recv, const QString &url);
    bool getpathandmd5(const QByteArray &data, QString &downloadxmlpath, QString &md5);
    bool downloadfile(const QString &path, QString filename);
public slots:
    void onreadyread();

private:
    QFile file;
    QNetworkReply *reply;
};

#endif // REFRESHXMLWORK_H
