#ifndef FM_TOOL_H
#define FM_TOOL_H
#include <QCoreApplication>
#include <QCryptographicHash>
#include <QString>
#include <QSettings>
#include <QVariant>


#include "config.h"

class Tool
{
public:
    static QVariant ReadCfg(QString section, QVariant defaultvalue = QVariant())
    {
        QString cfgfilepath = qApp->applicationDirPath() + QString("/") + QString(CFG_FILEMAE);
        return QSettings(cfgfilepath, QSettings::IniFormat).value(section, defaultvalue);
    }

   static void GetMD5(std::string src, std::string &des)
   {
       QByteArray data = QCryptographicHash::hash(QByteArray(src.data()), QCryptographicHash::Md5);
       des = std::string(data.toHex().toUpper().data());
   }

};

#endif // TOOL_H
