#include <QCoreApplication>
#include <QDebug>
#include <QDir>
#include "QsLog.h"
#include "config.h"
#include "control.h"

#ifdef FM_TEST

int main(int argc, char *argv[])
{
    QCoreApplication a(argc, argv);

    QString logDir = QString("%1/log").arg(QCoreApplication::applicationDirPath());
    QDir().mkdir(logDir);

    QsLogging::Logger &logger = QsLogging::Logger::instance();
    logger.setLoggingLevel(QsLogging::TraceLevel);
    QString logPath = QString("%1/%2").arg(logDir, "fmconpon.log");
    QsLogging::DestinationPtr fileDst(QsLogging::DestinationFactory::MakeFileDestination(
    logPath, QsLogging::EnableLogRotation, QsLogging::MaxSizeBytes(2*1024*1024), QsLogging::MaxOldLogCount(10)));
    logger.addDestination(fileDst);
    QsLogging::DestinationPtr consleDest(QsLogging::DestinationFactory::MakeDebugOutputDestination());
    logger.addDestination(consleDest);

    control con;
    con.start();


//    //NetWork net;

//    //QString error;
//    //QByteArray outdata;

//    //bool flag = net.listen(38888, error);

//    //QLOG_INFO() << flag << error;

//    //bool falg = NetWork::HttpPost(QString("http://172.16.13.48:9090"), "meximexi", outdata, error, 60);

//    //QLOG_INFO() << falg << error << outdata;

//    std::string src = "{\"code\":\"1231231231\"}", des, key, value, error;

//    QLOG_INFO() << src.data();


//    bool flag = fm_xmltojson::JsonConvertFront(src, des, key, value, error);

//    QLOG_INFO() << "JsonConvertFront end " << flag << error.data();

    return a.exec();
}

#else

#endif
